/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004BU\b\u0017\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u0010B;\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibraryProperResolverWithAttributes;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "repositories", "", "", "directLibs", "distributionKlib", "localKotlinDir", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "knownIrProviders", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;Ljava/util/List;)V", "(Ljava/util/List;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;Ljava/util/List;)V", "libraryMatch", "candidate", "unresolved", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "kotlin-util-klib"})
public abstract class KotlinLibraryProperResolverWithAttributes<L extends KotlinLibrary>
extends KotlinLibrarySearchPathResolver<L>
implements SearchPathResolver<L> {
    @NotNull
    private final List<String> knownIrProviders;

    public KotlinLibraryProperResolverWithAttributes(@NotNull List<String> directLibs, @Nullable String distributionKlib, boolean skipCurrentDir, @NotNull Logger logger, @NotNull List<String> knownIrProviders) {
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(knownIrProviders, "knownIrProviders");
        super(directLibs, distributionKlib, skipCurrentDir, logger);
        this.knownIrProviders = knownIrProviders;
    }

    @Deprecated(message="Please use the KotlinLibraryProperResolverWithAttributes constructor which does not has 'repositories' and 'localKotlinDir' value parameters", replaceWith=@ReplaceWith(expression="KotlinLibraryProperResolverWithAttributes<L>(directLibs, distributionKlib, skipCurrentDir, logger, knownIrProviders)", imports={}))
    public KotlinLibraryProperResolverWithAttributes(@NotNull List<String> repositories, @NotNull List<String> directLibs, @Nullable String distributionKlib, @Nullable String localKotlinDir, boolean skipCurrentDir, @NotNull Logger logger, @NotNull List<String> knownIrProviders) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(knownIrProviders, "knownIrProviders");
        this(directLibs, distributionKlib, skipCurrentDir, logger, knownIrProviders);
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate2, @NotNull UnresolvedLibrary unresolved) {
        KotlinAbiVersion candidateAbiVersion;
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        String candidatePath = candidate2.getLibraryFile().getAbsolutePath();
        String candidateCompilerVersion = candidate2.getVersions().getCompilerVersion();
        KotlinAbiVersion kotlinAbiVersion = candidateAbiVersion = candidate2.getVersions().getAbiVersion();
        if (!(kotlinAbiVersion != null ? kotlinAbiVersion.isCompatible() : false)) {
            this.getLogger().strongWarning("KLIB resolver: Skipping '" + candidatePath + "' having incompatible ABI version '" + candidateAbiVersion + "'. The library was produced by '" + candidateCompilerVersion + "' compiler.\nThe current Kotlin compiler can consume libraries having ABI version <= '" + KotlinAbiVersion.Companion.getCURRENT() + "'.\nPlease upgrade your Kotlin compiler version to consume this library.");
            return false;
        }
        String string2 = KotlinLibraryKt.getIrProviderName((BaseKotlinLibrary)candidate2);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            if (!this.knownIrProviders.contains(it)) {
                this.getLogger().strongWarning("KLIB resolver: Skipping '" + candidatePath + "'. The library requires unknown IR provider: " + it);
                return false;
            }
        }
        return true;
    }
}

