/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class TextMateBraceMatcher
implements BraceMatcher {
    public int getBraceTokenGroupId(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(0);
        }
        return -1;
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(1);
        }
        if (fileText == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(3);
        }
        if (iterator.getStart() == iterator.getEnd()) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        TextMateScope currentSelector = tokenType instanceof TextMateElementType ? ((TextMateElementType)tokenType).getScope() : null;
        return TextMateEditorUtils.findRightHighlightingPair(iterator.getStart(), fileText, currentSelector) != null;
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(4);
        }
        if (fileText == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(6);
        }
        if (iterator.getEnd() == iterator.getStart()) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        TextMateScope currentSelector = tokenType instanceof TextMateElementType ? ((TextMateElementType)tokenType).getScope() : null;
        return TextMateEditorUtils.findLeftHighlightingPair(iterator.getEnd(), fileText, currentSelector) != null;
    }

    public boolean isPairBraces(@NotNull IElementType tokenType, @NotNull IElementType tokenType2) {
        if (tokenType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(7);
        }
        if (tokenType2 == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(8);
        }
        return true;
    }

    public boolean isStructuralBrace(@NotNull HighlighterIterator iterator, @NotNull CharSequence text, @NotNull FileType fileType) {
        if (iterator == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(9);
        }
        if (text == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Nullable
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(12);
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(13);
        }
        return true;
    }

    public int getCodeConstructStart(@NotNull PsiFile psiFile, int openingBraceOffset) {
        if (psiFile == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(14);
        }
        return openingBraceOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBraceTokenGroupId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairBraces";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isStructuralBrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeConstructStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

