/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.toolchain;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleJava.toolchain.GradleDaemonJvmCriteriaMigrationNotification;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/toolchain/GradleDaemonJvmCriteriaMigrationNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "<init>", "()V", "onSuccess", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "kotlin.gradle.gradle-java"})
public final class GradleDaemonJvmCriteriaMigrationNotificationListener
implements ExternalSystemTaskNotificationListener {
    public void onSuccess(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (!Registry.Companion.is("gradle.daemon.jvm.criteria.suggest.migration")) {
            return;
        }
        if (!Intrinsics.areEqual((Object)id.getProjectSystemId(), (Object)GradleConstants.SYSTEM_ID)) {
            return;
        }
        if (id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
            return;
        }
        Project project = id.findProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(projectPath);
        if (gradleProjectSettings == null) {
            return;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"resolveGradleVersion(...)");
        GradleVersion gradleVersion2 = gradleVersion;
        if (GradleDaemonJvmHelper.isDaemonJvmCriteriaSupported((GradleVersion)gradleVersion2)) {
            Path path2 = Path.of(projectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            if (!GradleDaemonJvmHelper.isProjectUsingDaemonJvmCriteria((Path)path2, (GradleVersion)gradleVersion2)) {
                GradleDaemonJvmCriteriaMigrationNotification.INSTANCE.show(project2, projectPath);
            }
        }
    }
}

