/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilerType;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationCompilerResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.IncorrectCodeFragmentException;
import org.jetbrains.kotlin.idea.debugger.evaluate.K1KotlinCodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentPatcherKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerHandler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompilationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugForeignPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/K1KotlinCodeFragmentCompiler;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentCompiler;", "<init>", "()V", "compilerType", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;", "getCompilerType", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;", "compileCodeFragment", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/K1KotlinCodeFragmentCompiler$ErrorCheckingResult;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "compilerStrategy", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy;", "doAnalyze", "reportErrorDiagnosticIfAny", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "stats", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;", "isIllegalSuspendFunCallInCodeFragment", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "ErrorCheckingResult", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nK1KotlinCodeFragmentCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K1KotlinCodeFragmentCompiler.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/K1KotlinCodeFragmentCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n295#2,2:146\n774#2:148\n865#2,2:149\n295#2,2:151\n*S KotlinDebug\n*F\n+ 1 K1KotlinCodeFragmentCompiler.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/K1KotlinCodeFragmentCompiler\n*L\n95#1:146,2\n114#1:148\n114#1:149,2\n115#1:151,2\n*E\n"})
final class K1KotlinCodeFragmentCompiler
implements KotlinCodeFragmentCompiler {
    @NotNull
    private final CompilerType compilerType = CompilerType.IR;

    @Override
    @NotNull
    public CompilerType getCompilerType() {
        return this.compilerType;
    }

    @Override
    @NotNull
    public CompiledCodeFragmentData compileCodeFragment(@NotNull ExecutionContext context, @NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        DebugProcessImpl debugProcess = context.getDebugProcess();
        IRCodeFragmentCompilingStrategy compilerStrategy = new IRCodeFragmentCompilingStrategy(codeFragment);
        compilerStrategy.getStats$kotlin_jvm_debugger_evaluation_k1().setOrigin(XEvaluationOrigin.Companion.getOrigin((UserDataHolderBase)context.getEvaluationContext()));
        try {
            KotlinCodeFragmentPatcherKt.patchCodeFragment(context, codeFragment, compilerStrategy.getStats$kotlin_jvm_debugger_evaluation_k1());
        }
        catch (Exception e) {
            compilerStrategy.processError(e, codeFragment, CollectionsKt.emptyList(), context);
            throw e;
        }
        compilerStrategy.beforeAnalyzingCodeFragment();
        ErrorCheckingResult analysisResult = this.analyze(codeFragment, debugProcess, compilerStrategy);
        Diagnostic diagnostic = analysisResult.getIllegalSuspendFunCallDiagnostic();
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            KotlinEvaluatorBuilderKt.evaluationException(string);
            throw new KotlinNothingValueException();
        }
        CodeFragmentCompilerHandler compilerHandler = new CodeFragmentCompilerHandler(compilerStrategy);
        CompilationResult result2 = compilerHandler.compileCodeFragment(codeFragment, analysisResult.getModuleDescriptor(), analysisResult.getBindingContext(), context);
        KotlinEvaluator.Companion.logCompilation(codeFragment);
        return KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(result2, true);
    }

    private final ErrorCheckingResult analyze(KtCodeFragment codeFragment, DebugProcessImpl debugProcess, IRCodeFragmentCompilingStrategy compilerStrategy) {
        Result result2 = (Result)ReadAction.nonBlocking(() -> K1KotlinCodeFragmentCompiler.analyze$lambda$1(this, codeFragment, debugProcess, compilerStrategy)).executeSynchronously();
        Intrinsics.checkNotNull((Object)result2);
        Object object = result2.unbox-impl();
        ResultKt.throwOnFailure((Object)object);
        return (ErrorCheckingResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ErrorCheckingResult doAnalyze(KtCodeFragment codeFragment, DebugProcessImpl debugProcess, IRCodeFragmentCompilingStrategy compilerStrategy) {
        Object v4;
        BindingContext bindingContext;
        ModuleDescriptor moduleDescriptor;
        List<KtCodeFragment> list2;
        block5: {
            void $this$firstOrNull$iv;
            try {
                AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)codeFragment));
            }
            catch (IllegalArgumentException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
                KotlinEvaluatorBuilderKt.evaluationException(string);
                throw new KotlinNothingValueException();
            }
            ResolutionFacade resolutionFacade = CodeFragmentCompilerKt.getResolutionFacadeForCodeFragment(codeFragment);
            new DebugForeignPropertyDescriptorProvider(codeFragment, debugProcess).supplyDebugForeignProperties();
            AnalysisResult analysisResult = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade, (KtElement)codeFragment, null, 2, null);
            if (analysisResult.isError()) {
                KotlinEvaluatorBuilderKt.evaluationException(analysisResult.getError());
                throw new KotlinNothingValueException();
            }
            BindingContext bindingContext2 = analysisResult.getBindingContext();
            this.reportErrorDiagnosticIfAny(bindingContext2, codeFragment, compilerStrategy.getStats$kotlin_jvm_debugger_evaluation_k1());
            ModuleDescriptor moduleDescriptor2 = analysisResult.getModuleDescriptor();
            List<KtCodeFragment> list3 = Collections.singletonList(codeFragment);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(...)");
            Diagnostics diagnostics = bindingContext2.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
            Iterable iterable = (Iterable)diagnostics;
            list2 = list3;
            moduleDescriptor = moduleDescriptor2;
            bindingContext = bindingContext2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!this.isIllegalSuspendFunCallInCodeFragment(it, codeFragment)) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        Object var16_17 = v4;
        Diagnostic diagnostic = var16_17;
        List<KtCodeFragment> list4 = list2;
        ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
        BindingContext bindingContext3 = bindingContext;
        return new ErrorCheckingResult(bindingContext3, moduleDescriptor3, list4, diagnostic);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportErrorDiagnosticIfAny(BindingContext bindingContext, KtCodeFragment codeFragment, CodeFragmentCompilationStats stats) {
        Object v1;
        block3: {
            void $this$firstOrNull$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Diagnostics diagnostics = bindingContext.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
            Iterable iterable = (Iterable)diagnostics;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Diagnostic it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!K1KotlinCodeFragmentCompilerKt.access$getIGNORED_DIAGNOSTICS$p().contains(it.getFactory()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!(it.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)it.getPsiElement().getContainingFile(), (Object)codeFragment))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Diagnostic diagnostic = v1;
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            KotlinDebuggerEvaluatorStatisticsCollector.logAnalysisAndCompilationResult(codeFragment.getProject(), CompilerType.IR, EvaluationCompilerResult.COMPILATION_FAILURE, stats);
            String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            throw new IncorrectCodeFragmentException(string);
        }
    }

    private final boolean isIllegalSuspendFunCallInCodeFragment(Diagnostic $this$isIllegalSuspendFunCallInCodeFragment, KtCodeFragment codeFragment) {
        return $this$isIllegalSuspendFunCallInCodeFragment.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getPsiElement().getContainingFile(), (Object)codeFragment) && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getFactory(), (Object)Errors.ILLEGAL_SUSPEND_FUNCTION_CALL);
    }

    private static final Result analyze$lambda$1(K1KotlinCodeFragmentCompiler this$0, KtCodeFragment $codeFragment, DebugProcessImpl $debugProcess, IRCodeFragmentCompilingStrategy $compilerStrategy) {
        Object object;
        try {
            object = Result.constructor-impl((Object)this$0.doAnalyze($codeFragment, $debugProcess, $compilerStrategy));
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex));
        }
        return Result.box-impl((Object)object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/K1KotlinCodeFragmentCompiler$ErrorCheckingResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "illegalSuspendFunCallDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getFiles", "()Ljava/util/List;", "getIllegalSuspendFunCallDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation.k1"})
    private static final class ErrorCheckingResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final List<KtFile> files;
        @Nullable
        private final Diagnostic illegalSuspendFunCallDiagnostic;

        public ErrorCheckingResult(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.bindingContext = bindingContext;
            this.moduleDescriptor = moduleDescriptor;
            this.files = files;
            this.illegalSuspendFunCallDiagnostic = illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> getFiles() {
            return this.files;
        }

        @Nullable
        public final Diagnostic getIllegalSuspendFunCallDiagnostic() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor component2() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> component3() {
            return this.files;
        }

        @Nullable
        public final Diagnostic component4() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final ErrorCheckingResult copy(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new ErrorCheckingResult(bindingContext, moduleDescriptor, files, illegalSuspendFunCallDiagnostic);
        }

        public static /* synthetic */ ErrorCheckingResult copy$default(ErrorCheckingResult errorCheckingResult, BindingContext bindingContext, ModuleDescriptor moduleDescriptor, List list2, Diagnostic diagnostic, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext = errorCheckingResult.bindingContext;
            }
            if ((n & 2) != 0) {
                moduleDescriptor = errorCheckingResult.moduleDescriptor;
            }
            if ((n & 4) != 0) {
                list2 = errorCheckingResult.files;
            }
            if ((n & 8) != 0) {
                diagnostic = errorCheckingResult.illegalSuspendFunCallDiagnostic;
            }
            return errorCheckingResult.copy(bindingContext, moduleDescriptor, list2, diagnostic);
        }

        @NotNull
        public String toString() {
            return "ErrorCheckingResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ", illegalSuspendFunCallDiagnostic=" + this.illegalSuspendFunCallDiagnostic + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.moduleDescriptor.hashCode();
            result2 = result2 * 31 + ((Object)this.files).hashCode();
            result2 = result2 * 31 + (this.illegalSuspendFunCallDiagnostic == null ? 0 : this.illegalSuspendFunCallDiagnostic.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorCheckingResult)) {
                return false;
            }
            ErrorCheckingResult errorCheckingResult = (ErrorCheckingResult)other;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)errorCheckingResult.bindingContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)errorCheckingResult.moduleDescriptor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.files, errorCheckingResult.files)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.illegalSuspendFunCallDiagnostic, (Object)errorCheckingResult.illegalSuspendFunCallDiagnostic);
        }
    }
}

