/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageMatcher;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FileLanguageGlobalScope
extends DelegatingGlobalSearchScope {
    private final Project myProject;
    @NotNull
    private final Collection<? extends LanguageMatcher> myLanguageMatchers;

    FileLanguageGlobalScope(@NotNull Project project, @NotNull GlobalSearchScope baseScope, @NotNull Collection<? extends LanguageMatcher> languageMatchers) {
        if (project == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(0);
        }
        if (baseScope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(1);
        }
        if (languageMatchers == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(2);
        }
        super(baseScope);
        this.myProject = project;
        this.myLanguageMatchers = languageMatchers;
    }

    FileLanguageGlobalScope(Project project, GlobalSearchScope scope, LanguageMatcher matcher) {
        this(project, scope, Collections.singleton(matcher));
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(3);
        }
        return super.contains(file) && this.matchesLanguage(file);
    }

    private boolean matchesLanguage(@NotNull VirtualFile file) {
        Language baseLanguage;
        if (file == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(4);
        }
        if ((baseLanguage = LanguageUtil.getLanguageForPsi(this.myProject, file)) instanceof TemplateLanguage) {
            FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(file);
            if (viewProvider == null) {
                return false;
            }
            return ContainerUtil.or(viewProvider.getLanguages(), fileLanguage -> ContainerUtil.or(this.myLanguageMatchers, matcher -> matcher.matchesLanguage((Language)fileLanguage)));
        }
        if (baseLanguage != null) {
            return ContainerUtil.or(this.myLanguageMatchers, matcher -> matcher.matchesLanguage(baseLanguage));
        }
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(5);
        }
        if (scope instanceof FileLanguageGlobalScope) {
            FileLanguageGlobalScope other = (FileLanguageGlobalScope)scope;
            if (this.myBaseScope == other.myBaseScope) {
                Collection<? extends LanguageMatcher> intersection = ContainerUtil.intersection(this.myLanguageMatchers, other.myLanguageMatchers);
                if (intersection.isEmpty()) {
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                    if (globalSearchScope == null) {
                        FileLanguageGlobalScope.$$$reportNull$$$0(6);
                    }
                    return globalSearchScope;
                }
                return new FileLanguageGlobalScope(this.myProject, this.myBaseScope, intersection);
            }
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(8);
        }
        if (scope instanceof FileLanguageGlobalScope) {
            FileLanguageGlobalScope other = (FileLanguageGlobalScope)scope;
            if (this.myBaseScope == other.myBaseScope) {
                Set<? extends LanguageMatcher> intersection = ContainerUtil.union(this.myLanguageMatchers, other.myLanguageMatchers);
                return new FileLanguageGlobalScope(this.myProject, this.myBaseScope, intersection);
            }
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileLanguageGlobalScope scope = (FileLanguageGlobalScope)o;
        if (!this.myProject.equals(scope.myProject)) {
            return false;
        }
        return this.myLanguageMatchers.equals(scope.myLanguageMatchers);
    }

    @Override
    public int calcHashCode() {
        int result = super.calcHashCode();
        result = 31 * result + this.myProject.hashCode();
        result = 31 * result + this.myLanguageMatchers.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "(restricted by file languages: " + this.myLanguageMatchers + " in " + this.myBaseScope + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageMatchers";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FileLanguageGlobalScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FileLanguageGlobalScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchesLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

