/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.TypeBuilder;
import org.opengis.util.GenericName;

public abstract class PropertyTypeBuilder
extends TypeBuilder {
    private FeatureTypeBuilder owner;
    int minimumOccurs;
    int maximumOccurs;

    PropertyTypeBuilder(PropertyTypeBuilder propertyTypeBuilder) {
        super(propertyTypeBuilder);
        this.owner = propertyTypeBuilder.owner;
        this.minimumOccurs = propertyTypeBuilder.minimumOccurs;
        this.maximumOccurs = propertyTypeBuilder.maximumOccurs;
    }

    PropertyTypeBuilder(FeatureTypeBuilder featureTypeBuilder) {
        super(featureTypeBuilder.getLocale());
        this.owner = featureTypeBuilder;
        this.minimumOccurs = featureTypeBuilder.defaultMinimumOccurs;
        this.maximumOccurs = featureTypeBuilder.defaultMaximumOccurs;
    }

    final FeatureTypeBuilder owner() {
        this.ensureAlive(this.owner);
        return this.owner;
    }

    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    public PropertyTypeBuilder setMinimumOccurs(int n) {
        if (n != this.minimumOccurs) {
            if (n < 0) {
                throw new IllegalArgumentException(this.errors().getString((short)92, "occurs", n));
            }
            this.minimumOccurs = n;
            if (n > this.maximumOccurs) {
                this.maximumOccurs = n;
            }
            this.clearCache();
        }
        return this;
    }

    public final int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    public PropertyTypeBuilder setMaximumOccurs(int n) {
        if (n != this.maximumOccurs) {
            if (n < 0) {
                throw new IllegalArgumentException(this.errors().getString((short)92, "occurs", n));
            }
            this.maximumOccurs = n;
            if (n < this.minimumOccurs) {
                this.minimumOccurs = n;
            }
            this.clearCache();
        }
        return this;
    }

    boolean isIdentifier() {
        return false;
    }

    @Override
    final GenericName createLocalName(CharSequence charSequence) {
        this.ensureAlive(this.owner);
        return this.owner.createLocalName(charSequence);
    }

    @Override
    final GenericName createGenericName(CharSequence ... charSequenceArray) {
        this.ensureAlive(this.owner);
        return this.owner.createGenericName(charSequenceArray);
    }

    @Override
    void clearCache() {
        this.ensureAlive(this.owner);
        this.owner.clearCache();
    }

    @Override
    public abstract AbstractIdentifiedType build() throws IllegalStateException;

    final void dispose() {
        this.owner = null;
    }

    @Override
    public void remove() {
        if (this.owner != null) {
            this.owner.replace(this, null);
            this.dispose();
        }
    }
}

