/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Formatter;

public class Earth {
    private static final double earthRadius = 6371229.0;
    private double eccentricity;
    private double eccentricitySquared;
    private double equatorRadius;
    private double poleRadius;
    private double flattening;
    private String name = "earth";

    public Earth() {
        this(6371229.0);
    }

    public Earth(double radius) {
        this.equatorRadius = radius;
        this.poleRadius = radius;
        this.flattening = 0.0;
        this.eccentricity = 1.0;
        this.eccentricitySquared = 1.0;
    }

    public Earth(double equatorRadius, double poleRadius, double reciprocalFlattening) {
        this(equatorRadius, poleRadius, reciprocalFlattening, "earth");
    }

    public Earth(double equatorRadius, double poleRadius, double reciprocalFlattening, String name) {
        this.equatorRadius = equatorRadius;
        this.poleRadius = poleRadius;
        this.name = name;
        if (reciprocalFlattening != 0.0) {
            this.flattening = 1.0 / reciprocalFlattening;
            this.eccentricitySquared = 2.0 * this.flattening - this.flattening * this.flattening;
            poleRadius = equatorRadius * Math.sqrt(1.0 - this.eccentricitySquared);
        } else {
            this.eccentricitySquared = 1.0 - poleRadius * poleRadius / (equatorRadius * equatorRadius);
            this.flattening = 1.0 - poleRadius / equatorRadius;
        }
        this.eccentricity = Math.sqrt(this.eccentricitySquared);
    }

    public static double getRadius() {
        return 6371229.0;
    }

    public double getMajor() {
        return this.equatorRadius;
    }

    public double getMinor() {
        return this.poleRadius;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setEccentricity(double value) {
        this.eccentricity = value;
    }

    public double getEccentricity() {
        return this.eccentricity;
    }

    public void setEccentricitySquared(double value) {
        this.eccentricitySquared = value;
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared;
    }

    public void setEquatorRadius(double value) {
        this.equatorRadius = value;
    }

    public double getEquatorRadius() {
        return this.equatorRadius;
    }

    public void setPoleRadius(double value) {
        this.poleRadius = value;
    }

    public double getPoleRadius() {
        return this.poleRadius;
    }

    public void setFlattening(double value) {
        this.flattening = value;
    }

    public double getFlattening() {
        return this.flattening;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Earth)) {
            return false;
        }
        Earth oo = (Earth)o;
        return this.getMajor() == oo.getMajor() && this.getMinor() == oo.getMinor();
    }

    public String toString() {
        Formatter ff = new Formatter();
        ff.format("equatorRadius=%f inverseFlattening=%f", this.equatorRadius, 1.0 / this.flattening);
        return ff.toString();
    }
}

