#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::SellerDashboardAlertSeverityCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellerDashboardAlertSeverityCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::SellerDashboardAlertSeverityCodeType

=head1 DESCRIPTION

Whether the alert is identifying a problem or is informational.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Informational

The alert message may be of interest to you. <br>
For example, you might get a PowerSeller status informational message 
when your PowerSeller level has increased.<br>
You might get a policy compliance informational message when you
have no recent policy violations.<br>
You might get a buyer satisfaction informational message when 
you are providing excellent customer service.<br>
You might get a seller account informational message when
there is a new notice available about your payment status.



=cut


use constant Informational => scalar('Informational');


=head2 Warning

The alert message is identifying a problem.<br>
For example, you might get a PowerSeller status warning if you missed the 
PowerSeller sales requirements in the past month.<br>
You might get a policy compliance warning if you have recently listed
an item with excessive shipping costs.<br>
You might get a seller account warning when a collections message 
asks you to pay now to make sure no restrictions are placed on your account.



=cut


use constant Warning => scalar('Warning');


=head2 StrongWarning

The alert message indicates a serious problem.<br>
For example, you might get a PowerSeller status strong warning 
when you have lost your PowerSeller status because of policy violations.<br>
You might get a policy compliance strong warning when your account has
been restricted.



=cut


use constant StrongWarning => scalar('StrongWarning');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
