#!/usr/bin/perl

package eBay::API::XML::Call::GetAttributesCS::GetAttributesCSResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAttributesCSResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAttributesCS::GetAttributesCSResponseType

=head1 DESCRIPTION

Returns XML that describes how to present Item Specifics to a seller
and how to validate selected eBay attributes on the client before including
them in an AddItem call or related calls.
See the Developer's Guide for an overview of Item Specifics and details about
the eBay attribute model. Also returns the current version of the meta-data system.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAttributesCS::GetAttributesCSResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");



my @gaProperties = ( [ 'AttributeData', 'xs:string', '', '', '' ]
	, [ 'AttributeSystemVersion', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttributeData()

A string containing a list of all the attributes that are
applicable to the site (or characteristic sets in the request),
along with related meta-data.
The meta-data specifies all the possible values of each attribute,
the logic for presenting attributes to a user, and rules for
validating the user's selections. Individual
elements are not described in the eBay schema format.
For information about each element in the AttributeData string,
see the attribute model documentation in the
eBay Web Services guide (see links below).<br>
<br>
Because this is returned as a string, the XML markup elements
are escaped with character entity references (e.g.,
&amp;lt;eBay&amp;gt;&amp;lt;Attributes&amp;gt;
...).
See the appendices in the eBay Web Services guide for general
information about string data types.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrModel
Title: The Attribute Meta-Data Model
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DataTypes
Title: Data Types


#    Argument: 'xs:string'

=cut

sub setAttributeData {
  my $self = shift;
  $self->{'AttributeData'} = shift
}

=head2 getAttributeData()

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'xs:string'

=cut

sub getAttributeData {
  my $self = shift;
  return $self->{'AttributeData'};
}


=head2 setAttributeSystemVersion()

Current version of the Item Specifics meta-data system for
the site.
This value changes each time changes are made to the meta-data.
The current version value is not necessarily greater than
the previous value. Therefore, when comparing versions, only
compare whether the value has changed.

#    Argument: 'xs:string'

=cut

sub setAttributeSystemVersion {
  my $self = shift;
  $self->{'AttributeSystemVersion'} = shift
}

=head2 getAttributeSystemVersion()

  Returned: Always
  Details: DetailLevel: none
#    Returns: 'xs:string'

=cut

sub getAttributeSystemVersion {
  my $self = shift;
  return $self->{'AttributeSystemVersion'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
