/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.icc;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.icc.IccDirectory;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class IccReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        IccDirectory directory = metadata.getOrCreateDirectory(IccDirectory.class);
        try {
            directory.setInt(0, reader.getInt32(0));
            this.set4ByteString(directory, 4, reader);
            this.setInt32(directory, 8, reader);
            this.set4ByteString(directory, 12, reader);
            this.set4ByteString(directory, 16, reader);
            this.set4ByteString(directory, 20, reader);
            this.setDate(directory, 24, reader);
            this.set4ByteString(directory, 36, reader);
            this.set4ByteString(directory, 40, reader);
            this.setInt32(directory, 44, reader);
            this.set4ByteString(directory, 48, reader);
            int temp = reader.getInt32(52);
            if (temp != 0) {
                if (temp <= 0x20202020) {
                    directory.setInt(52, temp);
                } else {
                    directory.setString(52, IccReader.getStringFromInt32(temp));
                }
            }
            this.setInt32(directory, 64, reader);
            this.setInt64(directory, 56, reader);
            float[] xyz = new float[]{reader.getS15Fixed16(68), reader.getS15Fixed16(72), reader.getS15Fixed16(76)};
            directory.setObject(68, xyz);
            int tagCount = reader.getInt32(128);
            directory.setInt(128, tagCount);
            for (int i = 0; i < tagCount; ++i) {
                int pos = 132 + i * 12;
                int tagType = reader.getInt32(pos);
                int tagPtr = reader.getInt32(pos + 4);
                int tagLen = reader.getInt32(pos + 8);
                byte[] b = reader.getBytes(tagPtr, tagLen);
                directory.setByteArray(tagType, b);
            }
        }
        catch (BufferBoundsException e) {
            directory.addError(String.format("Reading ICC Header %s:%s", e.getClass().getSimpleName(), e.getMessage()));
        }
    }

    private void set4ByteString(@NotNull Directory directory, int tagType, @NotNull BufferReader reader) throws BufferBoundsException {
        int i = reader.getInt32(tagType);
        if (i != 0) {
            directory.setString(tagType, IccReader.getStringFromInt32(i));
        }
    }

    private void setInt32(@NotNull Directory directory, int tagType, @NotNull BufferReader reader) throws BufferBoundsException {
        int i = reader.getInt32(tagType);
        if (i != 0) {
            directory.setInt(tagType, i);
        }
    }

    private void setInt64(@NotNull Directory directory, int tagType, @NotNull BufferReader reader) throws BufferBoundsException {
        long l = reader.getInt64(tagType);
        if (l != 0L) {
            directory.setLong(tagType, l);
        }
    }

    private void setDate(@NotNull IccDirectory directory, int tagType, @NotNull BufferReader reader) throws BufferBoundsException {
        int y = reader.getUInt16(tagType);
        int m = reader.getUInt16(tagType + 2);
        int d = reader.getUInt16(tagType + 4);
        int h = reader.getUInt16(tagType + 6);
        int M = reader.getUInt16(tagType + 8);
        int s = reader.getUInt16(tagType + 10);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(y, m, d, h, M, s);
        Date value = calendar.getTime();
        directory.setDate(tagType, value);
    }

    @NotNull
    public static String getStringFromInt32(int d) {
        byte[] b = new byte[]{(byte)((d & 0xFF000000) >> 24), (byte)((d & 0xFF0000) >> 16), (byte)((d & 0xFF00) >> 8), (byte)(d & 0xFF)};
        return new String(b);
    }
}

