/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class XmlReportImpl
implements Report {
    private File outputFile;
    private PrintWriter out;
    private boolean withDocumentMD = false;
    private String epubCheckName = "epubcheck";
    private String epubCheckVersion;
    private String epubCheckDate = "2013-05-10";
    private String ePubName;
    private String creationDate;
    private String lastModifiedDate;
    private String identifier;
    private Set<String> titles = new LinkedHashSet<String>();
    private Set<String> creators = new LinkedHashSet<String>();
    private Set<String> contributors = new LinkedHashSet<String>();
    private String publisher;
    private Set<String> rights = new LinkedHashSet<String>();
    private String date;
    private String formatName;
    private String formatVersion;
    private long pagesCount;
    private long charsCount;
    private String language;
    private Set<String> embeddedFonts = new LinkedHashSet<String>();
    private Set<String> refFonts = new LinkedHashSet<String>();
    private Set<String> references = new LinkedHashSet<String>();
    private boolean hasEncryption;
    private boolean hasSignatures;
    private boolean hasAudio;
    private boolean hasVideo;
    private boolean hasFixedLayout;
    private boolean hasScripts;
    private List<String> warns = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private List<String> exceptions = new ArrayList<String>();
    private List<String> hints = new ArrayList<String>();

    public XmlReportImpl(File out, String ePubName, String versionEpubCheck) {
        this.outputFile = out;
        this.ePubName = ePubName;
        this.epubCheckVersion = versionEpubCheck;
    }

    public void setEpubVersion(EPUBVersion version) {
        this.formatVersion = version.toString();
    }

    @Override
    public void error(String resource, int line, int column, String message) {
        this.errors.add((resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + ")") + ": " + message);
    }

    @Override
    public void exception(String resource, Exception e) {
        this.exceptions.add((resource == null ? "" : "/" + resource) + e.getMessage());
    }

    @Override
    public void warning(String resource, int line, int column, String message) {
        this.warns.add((resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + ")") + ": " + message);
    }

    @Override
    public void hint(String resource, int line, int column, String message) {
        this.hints.add((resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + ")") + ": " + message);
    }

    @Override
    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public int getExceptionCount() {
        return this.exceptions.size();
    }

    @Override
    public int getWarningCount() {
        return this.warns.size();
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        switch (feature) {
            case TOOL_NAME: {
                this.epubCheckName = value;
                break;
            }
            case TOOL_VERSION: {
                this.epubCheckVersion = value;
                break;
            }
            case TOOL_DATE: {
                this.epubCheckDate = value;
                break;
            }
            case FORMAT_NAME: {
                this.formatName = value;
                break;
            }
            case FORMAT_VERSION: {
                this.formatVersion = value;
                break;
            }
            case CREATION_DATE: {
                this.creationDate = value;
                break;
            }
            case MODIFIED_DATE: {
                this.lastModifiedDate = value;
                break;
            }
            case PAGES_COUNT: {
                this.pagesCount = Long.parseLong(value);
                break;
            }
            case CHARS_COUNT: {
                this.charsCount += Long.parseLong(value);
                break;
            }
            case DECLARED_MIMETYPE: {
                if (value != null && value.startsWith("audio/")) {
                    this.hasAudio = true;
                    break;
                }
                if (value == null || !value.startsWith("video/")) break;
                this.hasVideo = true;
                break;
            }
            case FONT_EMBEDDED: {
                this.embeddedFonts.add(value);
                break;
            }
            case FONT_REFERENCE: {
                this.refFonts.add(value);
                break;
            }
            case REFERENCE: {
                this.references.add(value);
                break;
            }
            case DC_LANGUAGE: {
                this.language = value;
                break;
            }
            case DC_TITLE: {
                this.titles.add(value);
                break;
            }
            case DC_CREATOR: {
                this.creators.add(value);
                break;
            }
            case DC_CONTRIBUTOR: {
                this.contributors.add(value);
                break;
            }
            case DC_PUBLISHER: {
                this.publisher = value;
                break;
            }
            case DC_RIGHTS: {
                this.rights.add(value);
                break;
            }
            case DC_DATE: {
                this.date = value;
                break;
            }
            case UNIQUE_IDENT: {
                this.identifier = value;
                break;
            }
            case HAS_SIGNATURES: {
                this.hasSignatures = true;
                break;
            }
            case HAS_ENCRYPTION: {
                this.hasEncryption = true;
                break;
            }
            case HAS_FIXED_LAYOUT: {
                this.hasFixedLayout = true;
                break;
            }
            case HAS_SCRIPTS: {
                this.hasScripts = true;
            }
        }
    }

    private String getNameFromPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            return path;
        }
        return path.substring(lastSlash + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate() {
        this.out = null;
        int ident = 0;
        boolean generationOk = false;
        try {
            String[] cs;
            this.out = new PrintWriter(this.outputFile, "UTF-8");
            this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.output(ident++, "<jhove xmlns=\"http://hul.harvard.edu/ois/xml/ns/jhove\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" name=\"" + XmlReportImpl.encodeContent(this.epubCheckName) + "\" release=\"" + this.epubCheckVersion + "\" date=\"" + this.epubCheckDate + "\">");
            this.generateElement(ident, "date", XmlReportImpl.fromTime(System.currentTimeMillis()));
            this.output(ident++, "<repInfo uri=\"" + XmlReportImpl.encodeContent(this.getNameFromPath(this.ePubName)) + "\">");
            this.generateElement(ident, "created", this.creationDate);
            this.generateElement(ident, "lastModified", this.lastModifiedDate);
            if (this.formatName == null) {
                this.generateElement(ident, "format", "application/octet-stream");
            } else {
                this.generateElement(ident, "format", this.formatName);
            }
            this.generateElement(ident, "version", this.formatVersion);
            if (this.exceptions.isEmpty() && this.errors.isEmpty()) {
                this.generateElement(ident, "status", "Well-formed");
            } else {
                this.generateElement(ident, "status", "Not well-formed");
            }
            if (!(this.warns.isEmpty() && this.exceptions.isEmpty() && this.errors.isEmpty() && this.hints.isEmpty())) {
                this.output(ident++, "<messages>");
                for (String w : this.warns) {
                    this.generateElement(ident, "message", "WARN: " + XmlReportImpl.encodeContent(w));
                }
                for (String e : this.errors) {
                    this.generateElement(ident, "message", "ERROR: " + XmlReportImpl.encodeContent(e));
                }
                for (String e : this.exceptions) {
                    this.generateElement(ident, "message", "EXCEPTION: " + XmlReportImpl.encodeContent(e));
                }
                for (String e : this.hints) {
                    this.generateElement(ident, "message", "HINT: " + XmlReportImpl.encodeContent(e));
                }
                this.output(--ident, "</messages>");
            }
            this.generateElement(ident, "mimeType", this.formatName);
            this.output(ident++, "<properties>");
            this.generateProperty(ident, "PageCount", this.pagesCount);
            this.generateProperty(ident, "CharacterCount", this.charsCount);
            this.generateProperty(ident, "Language", this.language, "String");
            this.output(ident++, "<property><name>Info</name><values arity=\"List\" type=\"Property\">");
            this.generateProperty(ident, "Identifier", this.identifier, "String");
            this.generateProperty(ident, "CreationDate", this.creationDate, "Date");
            this.generateProperty(ident, "ModDate", this.lastModifiedDate, "Date");
            if (!this.titles.isEmpty()) {
                cs = this.titles.toArray(new String[0]);
                this.generateProperty(ident, "Title", cs, "String");
            }
            if (!this.creators.isEmpty()) {
                cs = this.creators.toArray(new String[0]);
                this.generateProperty(ident, "Creator", cs, "String");
            }
            if (!this.contributors.isEmpty()) {
                cs = this.contributors.toArray(new String[0]);
                this.generateProperty(ident, "Contributor", cs, "String");
            }
            this.generateProperty(ident, "Date", this.date, "String");
            this.generateProperty(ident, "Publisher", this.publisher, "String");
            if (!this.rights.isEmpty()) {
                cs = this.rights.toArray(new String[0]);
                this.generateProperty(ident, "Rights", cs, "String");
            }
            this.output(--ident, "</values></property>");
            if (!this.embeddedFonts.isEmpty() || !this.refFonts.isEmpty()) {
                this.output(ident++, "<property><name>Fonts</name><values arity=\"List\" type=\"Property\">");
                for (String f : this.embeddedFonts) {
                    this.output(ident++, "<property><name>Font</name><values arity=\"List\" type=\"Property\">");
                    this.generateProperty(ident, "FontName", XmlReportImpl.encodeContent(this.getNameFromPath(f)), "String");
                    this.generateProperty(ident, "FontFile", true);
                    this.output(--ident, "</values></property>");
                }
                for (String f : this.refFonts) {
                    this.output(ident++, "<property><name>Font</name><values arity=\"List\" type=\"Property\">");
                    this.generateProperty(ident, "FontName", XmlReportImpl.encodeContent(this.getNameFromPath(f)), "String");
                    this.generateProperty(ident, "FontFile", false);
                    this.output(--ident, "</values></property>");
                }
                this.output(--ident, "</values></property>");
            }
            if (!this.references.isEmpty()) {
                this.output(ident++, "<property><name>References</name><values arity=\"List\" type=\"Property\">");
                for (String r : this.references) {
                    this.generateProperty(ident, "Reference", XmlReportImpl.encodeContent(r), "String");
                }
                this.output(--ident, "</values></property>");
            }
            if (this.hasEncryption) {
                this.generateProperty(ident, "hasEncryption", this.hasEncryption);
            }
            if (this.hasSignatures) {
                this.generateProperty(ident, "hasSignatures", this.hasSignatures);
            }
            if (this.hasAudio) {
                this.generateProperty(ident, "hasAudio", this.hasAudio);
            }
            if (this.hasVideo) {
                this.generateProperty(ident, "hasVideo", this.hasVideo);
            }
            if (this.hasFixedLayout) {
                this.generateProperty(ident, "hasFixedLayout", this.hasFixedLayout);
            }
            if (this.hasScripts) {
                this.generateProperty(ident, "hasScripts", this.hasScripts);
            }
            if (this.withDocumentMD) {
                this.output(ident++, "<property><name>DocumentMDMetadata</name><values arity=\"Scalar\" type=\"Object\"><value>");
                this.generateDocumentMD(ident);
                this.output(--ident, "</value></values></property>");
            }
            this.output(--ident, "</properties>");
            this.output(--ident, "</repInfo>");
            this.output(--ident, "</jhove>");
            generationOk = true;
        }
        catch (FileNotFoundException e) {
            System.err.println("FileNotFound error: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("FileNotFound error: " + e.getMessage());
        }
        finally {
            this.out.close();
        }
        return generationOk;
    }

    private void generateDocumentMD(int ident) {
        this.output(ident++, "<docmd:document xmlns:docmd=\"http://www.fcla.edu/docmd\">");
        this.generateElement(ident, "docmd:PageCount", this.pagesCount);
        this.generateElement(ident, "docmd:CharacterCount", this.charsCount);
        this.generateElement(ident, "docmd:Language", this.language);
        for (String f : this.embeddedFonts) {
            this.output(ident, "<docmd:Font FontName=\"" + XmlReportImpl.encodeContent(this.getNameFromPath(f)) + "\" isEmbedded=\"true\" />");
        }
        for (String f : this.refFonts) {
            this.output(ident, "<docmd:Font FontName=\"" + XmlReportImpl.encodeContent(this.getNameFromPath(f)) + "\" isEmbedded=\"false\" />");
        }
        for (String r : this.references) {
            this.generateElement(ident, "docmd:Reference", XmlReportImpl.encodeContent(r));
        }
        if (this.hasAudio) {
            this.generateElement(ident, "docmd:Features", "hasAudio");
        }
        if (this.hasVideo) {
            this.generateElement(ident, "docmd:Features", "hasVideo");
        }
        if (this.hasFixedLayout) {
            this.generateElement(ident, "docmd:Features", "hasFixedLayout");
        }
        if (this.hasScripts) {
            this.generateElement(ident, "docmd:Features", "hasScripts");
        }
        this.output(--ident, "</docmd:document>");
    }

    private void output(int ident, String value) {
        char[] spaces = new char[ident];
        Arrays.fill(spaces, ' ');
        this.out.print(spaces);
        this.out.println(value);
    }

    private void generateElement(int ident, String name, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(name).append('>');
        sb.append(XmlReportImpl.encodeContent(value.trim()));
        sb.append("</").append(name).append('>');
        this.output(ident, sb.toString());
    }

    private void generateElement(int ident, String name, long value) {
        if (value == 0L) {
            return;
        }
        this.generateElement(ident, name, Long.toString(value));
    }

    private void generateProperty(int ident, String name, String[] value, String type) {
        if (value == null || value.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<property><name>").append(name).append("</name>");
        sb.append("<values arity=\"").append(value.length == 1 ? "Scalar" : "Array").append("\" type=\"").append(type).append("\">");
        for (String v : value) {
            sb.append("<value>").append(XmlReportImpl.encodeContent(v)).append("</value>");
        }
        sb.append("</values></property>");
        this.output(ident, sb.toString());
    }

    private void generateProperty(int ident, String name, String value, String type) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<property><name>").append(name).append("</name><values arity=\"Scalar\" type=\"").append(type).append("\">");
        sb.append("<value>").append(XmlReportImpl.encodeContent(value)).append("</value>");
        sb.append("</values></property>");
        this.output(ident, sb.toString());
    }

    private void generateProperty(int ident, String name, long value) {
        if (value == 0L) {
            return;
        }
        this.generateProperty(ident, name, Long.toString(value), "Long");
    }

    private void generateProperty(int ident, String name, boolean value) {
        this.generateProperty(ident, name, value ? "true" : "false", "Boolean");
    }

    private static String encodeContent(String content) {
        if (content == null) {
            content = "";
        }
        StringBuilder buffer = new StringBuilder(content);
        int n = 0;
        while ((n = buffer.indexOf("&", n)) > -1) {
            buffer.insert(n + 1, "amp;");
            n += 5;
        }
        n = 0;
        while ((n = buffer.indexOf("<", n)) > -1) {
            buffer.replace(n, n + 1, "&lt;");
            n += 4;
        }
        n = 0;
        while ((n = buffer.indexOf(">", n)) > -1) {
            buffer.replace(n, n + 1, "&gt;");
            n += 4;
        }
        return buffer.toString();
    }

    public static String fromTime(long time) {
        Date date = new Date(time);
        String formatted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(date);
        return formatted.substring(0, 22) + ":" + formatted.substring(22);
    }
}

