# NAME

ore

# ABSTRACT

Sugar for Perl 5 one-liners

# SYNOPSIS

    BEGIN {
      $ENV{New_File_Temp} = 'ft';
    }

    use ore;

    $ft

# DESCRIPTION

This package provides automatic object instantiation based on environment
variables. This package exists because I was bored and inspired by [new](https://metacpan.org/pod/new).

Simple command-line example with object instantiation:

    $ New_File_Temp=ft perl -More -e 'dd $ft'

    # "File::Temp"

Another simple command-line example returning a [Data::Object::Space](https://metacpan.org/pod/Data::Object::Space) object:

    $ Use_DBI=dbi perl -More -e 'dd $dbi->children'

    # [
    #   ...,
    #   bless(do{\(my $o = "DBI/DBD")}, "Data::Object::Space"),
    #   bless(do{\(my $o = "DBI/Profile")}, "Data::Object::Space"),
    #   bless(do{\(my $o = "DBI/ProfileData")}, "Data::Object::Space"),
    #   bless(do{\(my $o = "DBI/ProfileDumper")}, "Data::Object::Space"),
    #   ...,
    # ]

# AUTHOR

Al Newkirk, `awncorp@cpan.org`

# LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the ["license
file"](https://github.com/iamalnewkirk/ore/blob/master/LICENSE).

# PROJECT

[Wiki](https://github.com/iamalnewkirk/ore/wiki)

[Project](https://github.com/iamalnewkirk/ore)

[Initiatives](https://github.com/iamalnewkirk/ore/projects)

[Milestones](https://github.com/iamalnewkirk/ore/milestones)

[Contributing](https://github.com/iamalnewkirk/ore/blob/master/CONTRIBUTE.md)

[Issues](https://github.com/iamalnewkirk/ore/issues)
