package Bigtop::Example::GENBilling;

use strict;

use Gantry qw{ -TemplateEngine=TT };

our @ISA = qw( Gantry );

use Bigtop::Example::Billing::Status;
use Bigtop::Example::Billing::Company;
use Bigtop::Example::Billing::Customer;
use Bigtop::Example::Billing::LineItem;
use Bigtop::Example::Billing::Invoice;

##-----------------------------------------------------------------
## $self->init( $r )
##-----------------------------------------------------------------
#sub init {
#    my ( $self, $r ) = @_;
#
#    # process SUPER's init code
#    $self->SUPER::init( $r );
#
#} # END init


#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = shift;

    $self->stash->view->template( 'main.tt' );
    $self->stash->view->title( 'Billing' );

    $self->stash->view->data( {
        pages => [
            { link => 'status', label => 'Status' },
            { link => 'company', label => 'Companies' },
            { link => 'customer', label => 'Customers' },
            { link => 'lineitem', label => 'Line Items' },
            { link => 'invoice', label => 'Invoices' },
        ],
    } );
}

#-----------------------------------------------------------------
# $self->site_links( )
#-----------------------------------------------------------------
sub site_links {
    my $self = shift;

    return [
        { link => $self->app_rootp() . 'status', label => 'Status' },
        { link => $self->app_rootp() . 'company', label => 'Companies' },
        { link => $self->app_rootp() . 'customer', label => 'Customers' },
        { link => $self->app_rootp() . 'lineitem', label => 'Line Items' },
        { link => $self->app_rootp() . 'invoice', label => 'Invoices' },
    ];
}

1;

=head1 NAME

Bigtop::Example::GENBilling - generated support module for Billing

=head1 SYNOPSIS

In Billing:

    use base 'Bigtop::Example::GENBilling';

=head1 DESCRIPTION

This module was generated by Bigtop (and IS subject to regeneration) to
provide methods in support of the whole Billing
application.

Billing should inherit from this module.

=head1 METHODS

=over 4

=item init

=item do_main

=item site_links


=back

=head1 AUTHOR

Phil Crow

Tim Keefer

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
