use strict;
use warnings;
use Config;
use File::Spec;

my $file = $ARGV[0];

my (@parts_in, @parts_out);
@parts_in = @parts_out = File::Spec->splitdir($file);

$parts_in[-1] .= '.in';

my $out = File::Spec->catdir( 'ulib', @parts_out );
my $in  = File::Spec->catdir( 'usrc', @parts_in  );

my $t;
{
    local $/;
    open my $fh, '<', $in
        or die 'open: ', $in, ': ', $!;
    $t = <$fh>;
}

$t =~ s{\@SIZEOF_INT\@}      {$Config{intsize}}sg;
$t =~ s{\@SIZEOF_LONG\@}     {$Config{longsize}}sg;
$t =~ s{\@SIZEOF_LONG_LONG\@}{$Config{longlongsize}}sg;
$t =~ s{\@SIZEOF_SHORT\@}    {$Config{shortsize}}sg;

open my $fh, '>', $out
    or die 'open: ', $out, ': ', $!;
print $fh $t;

exit 0;
