
package App::Asciio::Arrows ;

use strict ; use warnings ;
use utf8 ;

use Clone ;

{

my %arrow_types = 
(
	dash =>
	[
		['origin',       '',  '*',   '',  '',  '', 1],
		['up',          '|',  '|',   '',  '', '^', 1],
		['down',        '|',  '|',   '',  '', 'v', 1],
		['left',        '-',  '-',   '',  '', '<', 1],
		['upleft',      '|',  '|',  '.', '-', '<', 1],
		['leftup',      '-',  '-', '\'', '|', '^', 1],
		['downleft',    '|',  '|', '\'', '-', '<', 1],
		['leftdown',    '-',  '-',  '.', '|', 'v', 1],
		['right',       '-',  '-',   '',  '', '>', 1],
		['upright',     '|',  '|',  '.', '-', '>', 1],
		['rightup',     '-',  '-', '\'', '|', '^', 1],
		['downright',   '|',  '|', '\'', '-', '>', 1],
		['rightdown',   '-',  '-',  '.', '|', 'v', 1],
		['45',          '/',  '/',   '',  '', '^', 1],
		['135',        '\\', '\\',   '',  '', 'v', 1],
		['225',         '/',  '/',   '',  '', 'v', 1],
		['315',        '\\', '\\',   '',  '', '^', 1],
	],
	dash_no_arrow =>
	[
		['origin',      '',  '*',   '',  '',  '', 1],
		['up',         '|',  '|',   '',  '', '.', 1],
		['down',       '|',  '|',   '',  '', '.', 1],
		['left',       '-',  '-',   '',  '', '.', 1],
		['upleft',     '|',  '|',  '.', '-', '.', 1],
		['leftup',     '-',  '-', '\'', '|', '.', 1],
		['downleft',   '|',  '|', '\'', '-', '.', 1],
		['leftdown',   '-',  '-',  '.', '|', '.', 1],
		['right',      '-',  '-',   '',  '', '.', 1],
		['upright',    '|',  '|',  '.', '-', '.', 1],
		['rightup',    '-',  '-', '\'', '|', '.', 1],
		['downright',  '|',  '|', '\'', '-', '.', 1],
		['rightdown',  '-',  '-',  '.', '|', '.', 1],
		['45',         '/',  '/',   '',  '', '.', 1],
		['135',       '\\', '\\',   '',  '', '.', 1],
		['225',        '/',  '/',   '',  '', '.', 1],
		['315',      ' \\', '\\',   '',  '', '.', 1],
	],
	dot =>
	[
		['origin',     '', '*',   '',  '',  '', 1],
		['up',        '.', '.',   '',  '', '^', 1],
		['down',      '.', '.',   '',  '', 'v', 1],
		['left',      '.', '.',   '',  '', '<', 1],
		['upleft',    '.', '.',  '.', '.', '<', 1],
		['leftup',    '.', '.', '\'', '.', '^', 1],
		['downleft',  '.', '.', '\'', '.', '<', 1],
		['leftdown',  '.', '.',  '.', '.', 'v', 1],
		['right',     '.', '.',   '',  '', '>', 1],
		['upright',   '.', '.',  '.', '.', '>', 1],
		['rightup',   '.', '.', '\'', '.', '^', 1],
		['downright', '.', '.', '\'', '.', '>', 1],
		['rightdown', '.', '.',  '.', '.', 'v', 1],
		['45',        '.', '.',   '',  '', '^', 1],
		['135',       '.', '.',   '',  '', 'v', 1],
		['225',       '.', '.',   '',  '', 'v', 1],
		['315',       '.', '.',   '',  '', '^', 1],
	],
	dot_no_arrow =>
	[
		['origin',     '', '*',   '',  '',  '', 1],
		['up',        '.', '.',   '',  '', '.', 1],
		['down',      '.', '.',   '',  '', '.', 1],
		['left',      '.', '.',   '',  '', '.', 1],
		['upleft',    '.', '.',  '.', '.', '.', 1],
		['leftup',    '.', '.', '\'', '.', '.', 1],
		['downleft',  '.', '.', '\'', '.', '.', 1],
		['leftdown',  '.', '.',  '.', '.', '.', 1],
		['right',     '.', '.',   '',  '', '.', 1],
		['upright',   '.', '.',  '.', '.', '.', 1],
		['rightup',   '.', '.', '\'', '.', '.', 1],
		['downright', '.', '.', '\'', '.', '.', 1],
		['rightdown', '.', '.',  '.', '.', '.', 1],
		['45',        '.', '.',   '',  '', '.', 1],
		['135',       '.', '.',   '',  '', '.', 1],
		['225',       '.', '.',   '',  '', '.', 1],
		['315',       '.', '.',   '',  '', '.', 1],
	],
	star =>
	[
		['origin',     '', '*', '',   '',  '', 1],
		['up',        '*', '*', '',   '', '^', 1],
		['down',      '*', '*', '',   '', 'v', 1],
		['left',      '*', '*', '',   '', '<', 1],
		['upleft',    '*', '*', '*', '*', '<', 1],
		['leftup',    '*', '*', '*', '*', '^', 1],
		['downleft',  '*', '*', '*', '*', '<', 1],
		['leftdown',  '*', '*', '*', '*', 'v', 1],
		['right',     '*', '*',  '',  '', '>', 1],
		['upright',   '*', '*', '*', '*', '>', 1],
		['rightup',   '*', '*', '*', '*', '^', 1],
		['downright', '*', '*', '*', '*', '>', 1],
		['rightdown', '*', '*', '*', '*', 'v', 1],
		['45',        '*', '*',  '',  '', '^', 1],
		['135',       '*', '*',  '',  '', 'v', 1],
		['225',       '*', '*',  '',  '', 'v', 1],
		['315',       '*', '*',  '',  '', '^', 1],
	],
	octo =>
	[
		['origin',    '', '#',  '',  '',  '', 1],
		['up',       '#', '#',  '',  '', '^', 1],
		['down',     '#', '#',  '',  '', 'v', 1],
		['left',     '#', '#',  '',  '', '<', 1],
		['upleft',   '#', '#', '#', '#', '<', 1],
		['leftup',   '#', '#', '#', '#', '^', 1],
		['downleft', '#', '#', '#', '#', '<', 1],
		['leftdown', '#', '#', '#', '#', 'v', 1],
		['right',    '#', '#',  '',  '', '>', 1],
		['upright',  '#', '#', '#', '#', '>', 1],
		['rightup',  '#', '#', '#', '#', '^', 1],
		['downright','#', '#', '#', '#', '>', 1],
		['rightdown','#', '#', '#', '#', 'v', 1],
		['45',       '#', '#',  '',  '', '^', 1],
		['135',      '#', '#',  '',  '', 'v', 1],
		['225',      '#', '#',  '',  '', 'v', 1],
		['315',      '#', '#',  '',  '', '^', 1],
	],
	unicode =>
	[
		['origin',      '',  '*',  '',  '',  '', 1],
		['up',         '│',  '│',  '',  '', '^', 1],
		['down',       '│',  '│',  '',  '', 'v', 1],
		['left',       '─',  '─',  '',  '', '<', 1],
		['upleft',     '│',  '│', '╮', '─', '<', 1],
		['leftup',     '─',  '─', '╰', '│', '^', 1],
		['downleft',   '│',  '│', '╯', '─', '<', 1],
		['leftdown',   '─',  '─', '╭', '│', 'v', 1],
		['right',      '─',  '─',  '',  '', '>', 1],
		['upright',    '│',  '│', '╭', '─', '>', 1],
		['rightup',    '─',  '─', '╯', '│', '^', 1],
		['downright',  '│',  '│', '╰', '─', '>', 1],
		['rightdown',  '─',  '─', '╮', '│', 'v', 1],
		['45',         '/',  '/',  '',  '', '^', 1],
		['135',       '\\', '\\',  '',  '', 'v', 1],
		['225',        '/',  '/',  '',  '', 'v', 1],
		['315',       '\\', '\\',  '',  '', '^', 1],
	],
	unicode_bold =>
	[
		['origin',      '',  '*',  '',  '',  '', 1],
		['up',         '┃',  '┃',  '',  '', '^', 1],
		['down',       '┃',  '┃',  '',  '', 'v', 1],
		['left',       '━',  '━',  '',  '', '<', 1],
		['upleft',     '┃',  '┃', '┓', '━', '<', 1],
		['leftup',     '━',  '━', '┗', '┃', '^', 1],
		['downleft',   '┃',  '┃', '┛', '━', '<', 1],
		['leftdown',   '━',  '━', '┏', '┃', 'v', 1],
		['right',      '━',  '━',  '',  '', '>', 1],
		['upright',    '┃',  '┃', '┏', '━', '>', 1],
		['rightup',    '━',  '━', '┛', '┃', '^', 1],
		['downright',  '┃',  '┃', '┗', '━', '>', 1],
		['rightdown',  '━',  '━', '┓', '┃', 'v', 1],
		['45',         '/',  '/',  '',  '', '^', 1],
		['135',       '\\', '\\',  '',  '', 'v', 1],
		['225',        '/',  '/',  '',  '', 'v', 1],
		['315',       '\\', '\\',  '',  '', '^', 1],
	],
	unicode_double_line =>
	[
		['origin',      '',  '*',  '',  '',  '', 1],
		['up',         '║',  '║',  '',  '', '^', 1],
		['down',       '║',  '║',  '',  '', 'v', 1],
		['left',       '═',  '═',  '',  '', '<', 1],
		['upleft',     '║',  '║', '╗', '═', '<', 1],
		['leftup',     '═',  '═', '╚', '║', '^', 1],
		['downleft',   '║',  '║', '╝', '═', '<', 1],
		['leftdown',   '═',  '═', '╔', '║', 'v', 1],
		['right',      '═',  '═',  '',  '', '>', 1],
		['upright',    '║',  '║', '╔', '═', '>', 1],
		['rightup',    '═',  '═', '╝', '║', '^', 1],
		['downright',  '║',  '║', '╚', '═', '>', 1],
		['rightdown',  '═',  '═', '╗', '║', 'v', 1],
		['45',         '/',  '/',  '',  '', '^', 1],
		['135',       '\\', '\\',  '',  '', 'v', 1],
		['225',        '/',  '/',  '',  '', 'v', 1],
		['315',       '\\', '\\',  '',  '', '^', 1],
	],
	unicode_no_arrow =>
	[
		['origin',      '',  '*',  '',  '',  '', 1],
		['up',         '│',  '│',  '',  '', '│', 1],
		['down',       '│',  '│',  '',  '', '│', 1],
		['left',       '─',  '─',  '',  '', '─', 1],
		['upleft',     '│',  '│', '╮', '─', '─', 1],
		['leftup',     '─',  '─', '╰', '│', '│', 1],
		['downleft',   '│',  '│', '╯', '─', '─', 1],
		['leftdown',   '─',  '─', '╭', '│', '│', 1],
		['right',      '─',  '─',  '',  '', '─', 1],
		['upright',    '│',  '│', '╭', '─', '─', 1],
		['rightup',    '─',  '─', '╯', '│', '│', 1],
		['downright',  '│',  '│', '╰', '─', '─', 1],
		['rightdown',  '─',  '─', '╮', '│', '│', 1],
		['45',         '/',  '/',  '',  '', '/', 1],
		['135',       '\\', '\\',  '',  '', '\\', 1],
		['225',        '/',  '/',  '',  '', '/', 1],
		['315',       '\\', '\\',  '',  '', '\\', 1],
	],
	unicode_hollow_dot =>
	[
		['origin',     '', '*',  '',  '',  '', 1],
		['up',        '∘', '∘',  '',  '', '^', 1],
		['down',      '∘', '∘',  '',  '', 'v', 1],
		['left',      '∘', '∘',  '',  '', '<', 1],
		['upleft',    '∘', '∘', '∘', '∘', '<', 1],
		['leftup',    '∘', '∘', '∘', '∘', '^', 1],
		['downleft',  '∘', '∘', '∘', '∘', '<', 1],
		['leftdown',  '∘', '∘', '∘', '∘', 'v', 1],
		['right',     '∘', '∘',  '', '',  '>', 1],
		['upright',   '∘', '∘', '∘', '∘', '>', 1],
		['rightup',   '∘', '∘', '∘', '∘', '^', 1],
		['downright', '∘', '∘', '∘', '∘', '>', 1],
		['rightdown', '∘', '∘', '∘', '∘', 'v', 1],
		['45',        '∘', '∘',  '',  '', '^', 1],
		['135',       '∘', '∘',  '',  '', 'v', 1],
		['225',       '∘', '∘',  '',  '', 'v', 1],
		['315',       '∘', '∘',  '',  '', '^', 1],
	],
	angled_arrow_dash =>
	[
		# name: $start, $body, $connection, $body_2, $end, $vertical, $diagonal_connection
		['origin'     , '*',  '?', '?', '?', '?', '?', '?', 1],
		['up'         , "'",  '|', '?', '?', '.', '?', '?', 1],
		['down'       , '.',  '|', '?', '?', "'", '?', '?', 1],
		['left'       , '-',  '-', '?', '?', '-', '?', '?', 1],
		['right'      , '-',  '-', '?', '?', '-', '?', '?', 1],
		['up-left'    , "'", '\\', '.', '-', '-', '|', "'", 1],
		['left-up'    , '-', '\\', "'", '-', '.', '|', "'", 1],
		['down-left'  , '.',  '/', "'", '-', '-', '|', "'", 1],
		['left-down'  , '-',  '/', '.', '-', "'", '|', "'", 1],
		['up-right'   , "'",  '/', '.', '-', '-', '|', "'", 1],
		['right-up'   , '-',  '/', "'", '-', '.', '|', "'", 1],
		['down-right' , '.', '\\', "'", '-', '-', '|', "'", 1],
		['right-down' , '-', '\\', '.', '-', "'", '|', "'", 1],
	],
	angled_arrow_unicode =>
	[
		['origin'     , '*',  '?', '?', '?', '?', '?', '?', 1],
		['up'         , "'",  '│', '?', '?', '.', '?', '?', 1],
		['down'       , '.',  '│', '?', '?', "'", '?', '?', 1],
		['left'       , '─',  '─', '?', '?', '─', '?', '?', 1],
		['right'      , '─',  '─', '?', '?', '─', '?', '?', 1],
		['up-left'    , "'", '\\', '.', '─', '─', '│', "'", 1],
		['left-up'    , '─', '\\', "'", '─', '.', '│', "'", 1],
		['down-left'  , '.',  '/', "'", '─', '─', '│', "'", 1],
		['left-down'  , '─',  '/', '.', '─', "'", '│', "'", 1],
		['up-right'   , "'",  '/', '.', '─', '─', '│', "'", 1],
		['right-up'   , '─',  '/', "'", '─', '.', '│', "'", 1],
		['down-right' , '.', '\\', "'", '─', '─', '│', "'", 1],
		['right-down' , '─', '\\', '.', '─', "'", '│', "'", 1],
	],
) ;

sub change_type
{
my ($self, $data, $create_undo_snapshot) = @_ ;

$create_undo_snapshot //= 1 ;

if(exists $arrow_types{$data->{TYPE}})
	{
	$self->create_undo_snapshot() if $create_undo_snapshot ;
	
	my $new_type = Clone::clone($arrow_types{$data->{TYPE}}) ;
	
	$data->{ELEMENT}->set_arrow_type($new_type) ;
	
	$self->update_display() if $create_undo_snapshot ;
	}
}

sub clone { my ($type) = @_ ; print "cloning arrow $type\n" ; Clone::clone($arrow_types{$type}) ; }

}
