
package SQL::Admin::Driver::Base;

use strict;
use warnings;

our $VERSION = v0.5.0;

######################################################################

use SQL::Admin;
use Module::Load qw();

######################################################################
######################################################################
sub new {                                # ;
    my $class = shift;
    $class = ref $class if ref $class;

    ##################################################################

    bless {
        @_,
        -sql_admin_search => [ $class, __PACKAGE__ ],
    }, $class;
}


######################################################################
######################################################################
sub _load_and_new {                      # ;
    my ($self, $what) = (shift, shift);
    my $retval;

    for (@{ $self->{-sql_admin_search} }) {
        $retval ||= eval { SQL::Admin->_load_and_new ($_ . '::' . $what, @_) };
    }

    ##################################################################

    $retval;
}


######################################################################
######################################################################
sub options {
    (
        'file|f=s@'
    )
}


######################################################################
######################################################################
sub evaluate {                           # ;
    shift->evaluator->evaluate (@_);
}


######################################################################
######################################################################
sub decompose {                          # ;
    shift->decomposer ->decompose (@_);
}


######################################################################
######################################################################
sub decomposer {                         # ;
    shift->_load_and_new ('Decompose', @_);
}


######################################################################
######################################################################
sub evaluator {                          # ;
    shift->_load_and_new ('Evaluate', @_);
}


######################################################################
######################################################################
sub producer {                           # ;
    shift->_load_and_new ('Producer', @_);
}


######################################################################
######################################################################
sub parser {                             # ;
    shift->_load_and_new ('Parser', @_);
}


######################################################################
######################################################################
sub load {                               # ;
    my ($self, $catalog, @params) = @_;

    $self->evaluate (
        $catalog,
        $self->parser (%$self )->load (@params)
    );
}


######################################################################
######################################################################
sub save {                               # ;
    my ($self, $catalog, @params) = @_;
    my $fh = \*STDOUT;

    if ($self->{file}) {
        my $file = $self->{file}[0];
        open $fh, '>', $file
          or die "Unable write to $file: $!\n";
    }

    ##################################################################

    print $fh $self->producer (@params)->produce (
        @{ $self->decompose ($catalog) }
    );
}


######################################################################
######################################################################

package SQL::Admin::Driver::Base;

1;

__END__

=pod

=head1 NAME

SQL::Admin::Driver::Base - driver base class

