# -*- perl -*-

use strict;
use Set::IntSpan 1.13;

my $N = 1;
sub Not { print "not " }
sub OK  { print "ok ", $N++, "\n" }

my @tests = 
(
 [ []   , 0, 0 ],

 [ [ 1 ], 0, 0 ],
 [ [ 1 ], 1, 0 ],
 [ [ 1 ], 2, 1 ],

 [ [ 1, 2 ], 0, 0 ],
 [ [ 1, 2 ], 1, 0 ],
 [ [ 1, 2 ], 2, 1 ],
 [ [ 1, 2 ], 3, 2 ],

 [ [ 1, 3 ], 0, 0 ],
 [ [ 1, 3 ], 1, 0 ],
 [ [ 1, 3 ], 2, 1 ],
 [ [ 1, 3 ], 3, 1 ],
 [ [ 1, 3 ], 4, 2 ],

 [ [ 1, 3, 5 ], 0, 0 ],
 [ [ 1, 3, 5 ], 1, 0 ],
 [ [ 1, 3, 5 ], 2, 1 ],
 [ [ 1, 3, 5 ], 3, 1 ],
 [ [ 1, 3, 5 ], 4, 2 ],
 [ [ 1, 3, 5 ], 5, 2 ],
 [ [ 1, 3, 5 ], 6, 3 ],

 [ [ 1, 3, 5, 7 ], 0, 0 ],
 [ [ 1, 3, 5, 7 ], 1, 0 ],
 [ [ 1, 3, 5, 7 ], 2, 1 ],
 [ [ 1, 3, 5, 7 ], 3, 1 ],
 [ [ 1, 3, 5, 7 ], 4, 2 ],
 [ [ 1, 3, 5, 7 ], 5, 2 ],
 [ [ 1, 3, 5, 7 ], 6, 3 ],
 [ [ 1, 3, 5, 7 ], 7, 3 ],
 [ [ 1, 3, 5, 7 ], 8, 4 ],

 [ [ 1, 3, 5, 7, 9 ],  0, 0 ],
 [ [ 1, 3, 5, 7, 9 ],  1, 0 ],
 [ [ 1, 3, 5, 7, 9 ],  2, 1 ],
 [ [ 1, 3, 5, 7, 9 ],  3, 1 ],
 [ [ 1, 3, 5, 7, 9 ],  4, 2 ],
 [ [ 1, 3, 5, 7, 9 ],  5, 2 ],
 [ [ 1, 3, 5, 7, 9 ],  6, 3 ],
 [ [ 1, 3, 5, 7, 9 ],  7, 3 ],
 [ [ 1, 3, 5, 7, 9 ],  8, 4 ],
 [ [ 1, 3, 5, 7, 9 ],  9, 4 ],
 [ [ 1, 3, 5, 7, 9 ], 10, 5 ],

 [ [ 1, 3, 5, 7, 9, 11 ],  0, 0 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  1, 0 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  2, 1 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  3, 1 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  4, 2 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  5, 2 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  6, 3 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  7, 3 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  8, 4 ],
 [ [ 1, 3, 5, 7, 9, 11 ],  9, 4 ],
 [ [ 1, 3, 5, 7, 9, 11 ], 10, 5 ],
 [ [ 1, 3, 5, 7, 9, 11 ], 11, 5 ],
 [ [ 1, 3, 5, 7, 9, 11 ], 12, 6 ],

 [ [ 1, 3, 5, 7, 9, 11, 13 ],  0, 0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  1, 0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  2, 1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  3, 1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  4, 2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  5, 2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  6, 3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  7, 3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  8, 4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ],  9, 4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ], 10, 5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ], 11, 5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ], 12, 6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ], 13, 6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13 ], 14, 7 ],

 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  0, 0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  1, 0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  2, 1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  3, 1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  4, 2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  5, 2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  6, 3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  7, 3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  8, 4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ],  9, 4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 10, 5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 11, 5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 12, 6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 13, 6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 14, 7 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 15, 7 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15 ], 16, 8 ],

 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  0, 0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  1, 0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  2, 1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  3, 1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  4, 2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  5, 2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  6, 3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  7, 3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  8, 4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ],  9, 4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 10, 5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 11, 5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 12, 6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 13, 6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 14, 7 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 15, 7 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 16, 8 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 17, 8 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17 ], 18, 9 ],

 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  0,  0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  1,  0 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  2,  1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  3,  1 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  4,  2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  5,  2 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  6,  3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  7,  3 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  8,  4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ],  9,  4 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 10,  5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 11,  5 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 12,  6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 13,  6 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 14,  7 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 15,  7 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 16,  8 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 17,  8 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 18,  9 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 19,  9 ],
 [ [ 1, 3, 5, 7, 9, 11, 13, 15, 17, 19 ], 20, 10 ],
);


print "1..", scalar @tests, "\n";

for my $test (@tests)
{
    my($edges, $target, $expected) = @$test;
    my $actual = Set::IntSpan::_bsearch($edges, $target);
    $expected==$actual or Not; OK;
}
