// Generated by CoffeeScript 1.12.8

/*
LemonLDAP::NG WebAuthn verify script
 */

(function() {
  var check, setMsg, webAuthnError;

  setMsg = function(msg, level) {
    $('#msg').attr('trspan', msg);
    $('#msg').html(window.translate(msg));
    $('#color').removeClass('message-positive message-warning message-danger alert-success alert-warning alert-danger');
    $('#color').addClass("message-" + level);
    if (level === 'positive') {
      level = 'success';
    }
    return $('#color').addClass("alert-" + level);
  };

  webAuthnError = function(error) {
    switch (error.name) {
      case 'unsupported':
        return setMsg('webAuthnUnsupported', 'warning');
      default:
        return setMsg('webAuthnBrowserFailed', 'danger');
    }
  };

  check = function() {
    var e, request;
    e = jQuery.Event("webauthnAttempt");
    $(document).trigger(e);
    if (!e.isDefaultPrevented()) {
      setMsg('webAuthnBrowserInProgress', 'warning');
      request = window.datas.request;
      return WebAuthnUI.WebAuthnUI.getCredential(request).then(function(response) {
        e = jQuery.Event("webauthnSuccess");
        $(document).trigger(e, [response]);
        if (!e.isDefaultPrevented()) {
          $('#credential').val(JSON.stringify(response));
          return $('#verify-form').submit();
        }
      })["catch"](function(error) {
        e = jQuery.Event("webauthnFailure");
        $(document).trigger(e, [error]);
        if (!e.isDefaultPrevented()) {
          return webAuthnError(error);
        }
      });
    }
  };

  $(document).ready(function() {
    setTimeout(check, 1000);
    return $('#retrybutton').on('click', check);
  });

}).call(this);
