use strict;
use warnings;

use Test::More;
use PDL;
use PDL::IO::Image;
use Test::Number::Delta within => 0.0000001;

my $expected = [
 [
  [ 19,201,206, 77,155, 96, 73,168,120,  1,182,136, 36,234,210,200, 71],
  [236, 88, 62,224,  7,193,128,144,184,  5,227, 60, 35,190, 18,229,178],
  [216, 49,236,109, 68,226,146,150,180, 40,249,192,246,129,117, 10,231],
  [ 39,103,161,141,221,121, 48,104, 46,124,107,107,142,173, 90,190, 56],
  [175,141,199, 65,  0,225,122,183, 44,248,133, 70,148, 26, 91, 53,252],
  [153,163, 61,190,104, 18, 12,212,  8, 73,228,155,119,158, 71,121, 71],
  [126,  2, 74,137, 80,157,201,170,117,118,197,243,105,143,104,216,129],
  [ 98, 90,173, 96,165,  4,247,162,120,195,  6,192,201, 67,233,189,108],
  [224,127,166,199, 70,183,100,121, 19,186,233,231,217, 19, 79, 20, 49],
  [145,214,173, 53,253,104,182, 35, 78,144,180,112,139,126,203, 28,250],
  [ 22,171,128,201,151,190,111,214,224,116,230,195,221, 37, 16,242, 32],
  [ 94,249,166, 52, 16,162,220,167,131,205, 10,103,117, 59,121, 96, 73],
  [187, 79,252,188,181,251,118,247,142, 43,162,110,170,242, 20,121, 72],
  [ 72, 71,  2, 15,133,194, 59,139, 14,193,198,104,197,108, 37,166,131],
  [ 40,242,165, 33,  0,183, 57, 86,191,209,156,254,173, 74,131,255,139],
  [ 15, 30,105,200,105, 71,  5,129, 37,176,238, 76, 79, 84,102, 88,233],
  [235,140,247,134,182, 24,250, 55,106,202, 16,163,116,176,146,194,110],
  [236,200, 32,  2, 39, 67,254, 14, 75, 54, 93, 68,192,116, 46, 23,195],
  [253,188, 59, 10,195,145,128, 80,139,221, 76,  7,149,176,133,189,248],
  [252, 40,114, 73,200, 97,124,141,109, 90, 34,  7, 90,164,155,223, 57],
  [104,144, 49,217, 49,214,144,220,163,122,118,114,209,209,183, 35,141],
  [173,128,254,112,105,217, 37,227,229, 72, 12,245, 43,141,101, 67,212],
  [  5, 16,186,230,190, 10,123, 70,190,173,168,102,140, 64,107,103,123],
 ],
 [
  [ 39,236, 66,202,180,148, 42, 20,235, 82,214, 35, 48, 60,201,166, 63],
  [ 64, 85,216, 88, 60,110,159, 12, 73,  2, 36,136,101,247,117,208,109],
  [126, 57,209,138,218,241,167,239, 70,227, 20, 42, 43, 35,119,205, 63],
  [204, 66,185,193,243, 66,217,114, 87,183,135,123, 83,142,116,222, 38],
  [184, 75,165, 12,246,230,108, 56, 15, 76,123, 52,210, 86,  7,173,201],
  [ 41,211, 59, 10,102,205, 35, 17, 67,219,159,255,103,105,186, 49,195],
  [  4, 59,152, 55,131,180,171, 73,  5, 56,114,184, 89,184,120, 47,  0],
  [160, 40,230,113,174, 99,116,196,141,199,152,111, 69,139, 72, 56,251],
  [ 85,206, 12, 18,248, 48,220, 55,126,181, 41, 82, 97,210,109,245,103],
  [ 56,  2, 72,  1, 94,174,249,149, 61,136, 65,154,150, 74,114,251,125],
  [210, 53,142,120,218,225, 42,251,178,  7, 31,132,  8,178,154, 34,111],
  [102,200,172,217,103, 29,120,147, 77,191,211, 11,110, 98,253,229, 39],
  [142,  0,162,141,173, 29,122,140,211, 31,133,249,157, 81,238,167, 27],
  [112, 73,  1, 28, 81,185, 50,222,140, 19, 99,105,240,159, 26,159, 15],
  [159, 59, 74,152, 74,190, 41,227, 97,149, 83, 92,253,211,230, 38,207],
  [156, 89,183,105,225,102,181,196,113,249,226,163,105,243, 84,  3,146],
  [ 74,207, 56,161, 81,121,224,245,167,192, 97,215,159,176,  1,180,159],
  [130, 91,115, 78,172, 70, 91,255, 67,219,151, 64,231,203,226,253, 14],
  [158, 97,  8,242, 16, 53,141,228, 40,202, 66, 91, 62,106,198,115,143],
  [ 39, 20, 54,137,145,115,110,119, 79,201, 70,183, 34,190,139, 34, 84],
  [143,200,198, 21,  0, 23,168,234, 83,216,173,140,170, 49, 77,103,190],
  [128, 71, 38, 85,165,242, 98, 85, 89, 84,243,238, 95,174,245,176,219],
  [157,  0,  2,141,127,159,221, 68, 61,141, 47, 77, 36,195,219, 31,  1],
 ],
 [
  [218,171, 17, 14,203, 51,110,244,154,245,145,118,233,190,117,251,  6],
  [161,101,147,118,118, 32,163,135, 69, 63,237,243,128, 15,255, 17,134],
  [198,213,174, 62, 60,177,  9, 70, 11,247,254,146, 70, 14,225,238,164],
  [ 17, 38, 58, 89, 96, 64,223,103,199,216, 77,183, 83,217,252,189,152],
  [ 84,212,228,112,215, 89,162,243, 38,144,104,200,243,  5, 59,111,142],
  [205, 65,186, 34,252, 12, 25,124,102,228,212,231, 45,216,241, 48,223],
  [235,217, 67,176, 18,120,128,162, 92,232, 69, 10,253,107,181, 92,147],
  [192, 65,160, 96,148, 13,124,201, 36,154, 64,225,193,221,206, 64, 97],
  [ 52,212,255,216, 79, 57, 10,243,138, 39,169, 11,200,154,114, 73, 89],
  [216,121, 48,229,196,  5,172,246,101,138, 52, 28,155, 60, 66, 59, 87],
  [245,176,  0, 81,196, 52, 26,145,230,157, 31,196,105,243,205,187, 88],
  [ 45,133,252,156,156,170,210,110,186,218,196,156,127,143,210,104,227],
  [ 40,107, 68,193,246,130, 65,182, 56,159,108, 37,169,102,230, 17,148],
  [107,251,237, 10,200, 14, 14, 40, 83,137,226, 15,229,180,157,132,146],
  [169,119,202, 61, 48, 53,186,118,214, 15,159,253,242,174,228,223,248],
  [ 97, 21,141,212, 49, 65,216,144,255, 67, 59, 29, 81,246, 88,125,250],
  [229, 15, 18, 62,115, 31,105,166, 13,175, 51, 26,109,174,208,127,112],
  [112, 19,109,135,107,169, 48, 91,133,208,189,142,216,177,184, 67, 74],
  [ 45, 65, 89,244, 80,170,245,175, 76,182, 80,183, 39,153,104,201,  5],
  [ 84,134,172, 52,153, 46,124,224,227,126,179,158,228,131, 74,174,242],
  [140,220, 32,161,  3, 61,194, 41,213, 96, 11,199,243,248,203,191,239],
  [196,247, 35, 59,226, 73, 16, 36, 21,  6,125,241,113,172, 80, 82, 65],
  [210,219,138,156,  7,100,108,151,240,235,175, 99,111,209,157,100, 33],
 ],
];

my $expected_region = [
 [
  [190,104, 18, 12,212,  8, 73,228,155],
  [137, 80,157,201,170,117,118,197,243],
  [ 96,165,  4,247,162,120,195,  6,192],
  [199, 70,183,100,121, 19,186,233,231],
  [ 53,253,104,182, 35, 78,144,180,112],
  [201,151,190,111,214,224,116,230,195],
  [ 52, 16,162,220,167,131,205, 10,103],
  [188,181,251,118,247,142, 43,162,110],
  [ 15,133,194, 59,139, 14,193,198,104],
  [ 33,  0,183, 57, 86,191,209,156,254],
  [200,105, 71,  5,129, 37,176,238, 76],
  [134,182, 24,250, 55,106,202, 16,163],
 ],
 [
  [ 10,102,205, 35, 17, 67,219,159,255],
  [ 55,131,180,171, 73,  5, 56,114,184],
  [113,174, 99,116,196,141,199,152,111],
  [ 18,248, 48,220, 55,126,181, 41, 82],
  [  1, 94,174,249,149, 61,136, 65,154],
  [120,218,225, 42,251,178,  7, 31,132],
  [217,103, 29,120,147, 77,191,211, 11],
  [141,173, 29,122,140,211, 31,133,249],
  [ 28, 81,185, 50,222,140, 19, 99,105],
  [152, 74,190, 41,227, 97,149, 83, 92],
  [105,225,102,181,196,113,249,226,163],
  [161, 81,121,224,245,167,192, 97,215],
 ],
 [
  [ 34,252, 12, 25,124,102,228,212,231],
  [176, 18,120,128,162, 92,232, 69, 10],
  [ 96,148, 13,124,201, 36,154, 64,225],
  [216, 79, 57, 10,243,138, 39,169, 11],
  [229,196,  5,172,246,101,138, 52, 28],
  [ 81,196, 52, 26,145,230,157, 31,196],
  [156,156,170,210,110,186,218,196,156],
  [193,246,130, 65,182, 56,159,108, 37],
  [ 10,200, 14, 14, 40, 83,137,226, 15],
  [ 61, 48, 53,186,118,214, 15,159,253],
  [212, 49, 65,216,144,255, 67, 59, 29],
  [ 62,115, 31,105,166, 13,175, 51, 26],
 ],
];

for my $file (<t/bpp-24/*.*>) {
  my $pimage = PDL::IO::Image->new_from_file($file);
  is($pimage->get_image_type , "BITMAP", "get_image_type: $file");
  is($pimage->get_color_type , "RGB", "get_color_type: $file");
  is($pimage->get_colors_used, 0 , "get_colors_used: $file");
  is($pimage->get_width      , 17, "get_width: $file");
  is($pimage->get_height     , 23, "get_height: $file");
  is($pimage->get_bpp        , 24, "get_bpp: $file");
  my $pix = $pimage->pixels_to_pdl;
  is($pix->info, 'PDL: Byte D [17,23,3]', "info: $file");
  unless ($file =~ /\.(jng|jpg|jpeg|webp)$/i) {
    is($pix->sum, 151877, "sum: $file");
    delta_ok($pix->unpdl, $expected, "pixels: $file");
  }
  #region
  $pix = $pimage->pixels_to_pdl(3,11,5,16);
  is($pix->info, 'PDL: Byte D [9,12,3]',    "reg.info: $file");
  unless ($file =~ /\.(jng|jpg|jpeg|webp)$/i) {
    is($pix->sum, 41645,                    "reg.sum: $file");
    delta_ok($pix->unpdl, $expected_region, "reg.pixels: $file");
  }
  $pix = $pimage->pixels_to_pdl(3,-5,5,-6);
  is($pix->info, 'PDL: Byte D [9,12,3]',    "regneg.info: $file");
  unless ($file =~ /\.(jng|jpg|jpeg|webp)$/i) {
    is($pix->sum, 41645,                    "regneg.sum: $file");
    delta_ok($pix->unpdl, $expected_region, "regneg.pixels: $file");
  }
}

done_testing();