# Generated by default/object.tt
package Paws::MediaTailor::RequestOutputItem;
  use Moose;
  has DashPlaylistSettings => (is => 'ro', isa => 'Paws::MediaTailor::DashPlaylistSettings');
  has HlsPlaylistSettings => (is => 'ro', isa => 'Paws::MediaTailor::HlsPlaylistSettings');
  has ManifestName => (is => 'ro', isa => 'Str', required => 1);
  has SourceGroup => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::RequestOutputItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::RequestOutputItem object:

  $service_obj->Method(Att1 => { DashPlaylistSettings => $value, ..., SourceGroup => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::RequestOutputItem object:

  $result = $service_obj->Method(...);
  $result->Att1->DashPlaylistSettings

=head1 DESCRIPTION

The ouput configuration for this channel.

=head1 ATTRIBUTES


=head2 DashPlaylistSettings => L<Paws::MediaTailor::DashPlaylistSettings>

DASH manifest configuration parameters.


=head2 HlsPlaylistSettings => L<Paws::MediaTailor::HlsPlaylistSettings>

HLS playlist configuration parameters.


=head2 B<REQUIRED> ManifestName => Str

The name of the manifest for the channel. The name appears in the
PlaybackUrl.


=head2 B<REQUIRED> SourceGroup => Str

A string used to match which HttpPackageConfiguration is used for each
VodSource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

