/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import java.util.Arrays;

public class SequenceSampler
implements BestSequenceFinder {
    private static String arrayToString(int[] x) {
        StringBuilder sb = new StringBuilder("(");
        for (int j = 0; j < x.length; ++j) {
            sb.append(x[j]);
            if (j == x.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static void main(String[] args) {
        SequenceSampler ti = new SequenceSampler();
        TestSequenceModel ts = new TestSequenceModel();
        int[] bestTags = ti.bestSequence(ts);
        System.out.println("The best sequence is ... " + SequenceSampler.arrayToString(bestTags));
    }

    @Override
    public int[] bestSequence(SequenceModel ts) {
        int[] sample = new int[ts.length() + ts.leftWindow()];
        for (int pos = ts.leftWindow(); pos < sample.length; ++pos) {
            double[] scores = ts.scoresOf(sample, pos);
            double total = 0.0;
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.exp(scores[i]);
            }
            ArrayMath.normalize(scores);
            int l = ArrayMath.sampleFromDistribution(scores);
            sample[pos] = ts.getPossibleValues(pos)[l];
        }
        return sample;
    }

    private static class TestSequenceModel
    implements SequenceModel {
        private int[] correctTags = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 6, 5, 4, 3, 2, 1, 0, 0};
        private int[] allTags = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        private int[] midTags = new int[]{0, 1, 2, 3};
        private int[] nullTags = new int[]{0};

        private TestSequenceModel() {
        }

        @Override
        public int length() {
            return this.correctTags.length - this.leftWindow() - this.rightWindow();
        }

        @Override
        public int leftWindow() {
            return 2;
        }

        @Override
        public int rightWindow() {
            return 0;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.leftWindow() || pos >= this.leftWindow() + this.length()) {
                return this.nullTags;
            }
            if (this.correctTags[pos] < 4) {
                return this.midTags;
            }
            return this.allTags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            return 1.0;
        }

        @Override
        public double scoreOf(int[] sequence) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int[] tagsAtPos = this.getPossibleValues(pos);
            double[] scores = new double[tagsAtPos.length];
            Arrays.fill(scores, 1.0);
            return scores;
        }
    }
}

