/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.pascal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class Alignment {
    public char[] longForm;
    public char[] shortForm;
    public int[] pointers;
    private static final char[] spaces = "                      ".toCharArray();

    public Alignment(char[] longForm, char[] shortForm, int[] pointers) {
        this.longForm = longForm;
        this.shortForm = shortForm;
        this.pointers = pointers;
    }

    public void serialize(PrintWriter writer) {
        writer.println(new String(this.longForm));
        writer.println(new String(this.shortForm));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.pointers.length; ++i) {
            sb.append(this.pointers[i] + " ");
        }
        writer.println(sb.toString());
    }

    public Alignment(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException();
        }
        this.longForm = line.toCharArray();
        line = reader.readLine();
        if (line == null) {
            throw new IOException();
        }
        this.shortForm = line.toCharArray();
        line = reader.readLine();
        if (line == null) {
            throw new IOException();
        }
        String[] pstrings = line.split("\\s+");
        if (pstrings.length != this.shortForm.length) {
            throw new IOException("Number of pointers != size of short form");
        }
        this.pointers = new int[pstrings.length];
        for (int i = 0; i < this.pointers.length; ++i) {
            this.pointers[i] = Integer.parseInt(pstrings[i]);
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(this.longForm);
        buf.append("\n");
        buf.append(spaces, 0, prefix.length());
        int l = 0;
        for (int s = 0; s < this.shortForm.length; ++s) {
            if (this.pointers[s] == -1) continue;
            while (l < this.longForm.length && this.pointers[s] != l) {
                buf.append(" ");
                ++l;
            }
            if (l >= this.longForm.length) continue;
            buf.append(this.shortForm[s]);
            ++l;
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Alignment)) {
            return false;
        }
        Alignment cmp = (Alignment)o;
        return Arrays.equals(this.longForm, cmp.longForm) && Arrays.equals(this.shortForm, cmp.shortForm) && Arrays.equals(this.pointers, cmp.pointers);
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.pointers.length; ++i) {
            code += this.pointers[i];
            code *= 31;
        }
        return code;
    }
}

