# Generated by default/object.tt
package Paws::AutoScaling::PredictiveScalingConfiguration;
  use Moose;
  has MaxCapacityBreachBehavior => (is => 'ro', isa => 'Str');
  has MaxCapacityBuffer => (is => 'ro', isa => 'Int');
  has MetricSpecifications => (is => 'ro', isa => 'ArrayRef[Paws::AutoScaling::PredictiveScalingMetricSpecification]', required => 1);
  has Mode => (is => 'ro', isa => 'Str');
  has SchedulingBufferTime => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::PredictiveScalingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::PredictiveScalingConfiguration object:

  $service_obj->Method(Att1 => { MaxCapacityBreachBehavior => $value, ..., SchedulingBufferTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::PredictiveScalingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->MaxCapacityBreachBehavior

=head1 DESCRIPTION

Represents a predictive scaling policy configuration to use with Amazon
EC2 Auto Scaling.

=head1 ATTRIBUTES


=head2 MaxCapacityBreachBehavior => Str

Defines the behavior that should be applied if the forecast capacity
approaches or exceeds the maximum capacity of the Auto Scaling group.
Defaults to C<HonorMaxCapacity> if not specified.

The following are possible values:

=over

=item *

C<HonorMaxCapacity> - Amazon EC2 Auto Scaling cannot scale out capacity
higher than the maximum capacity. The maximum capacity is enforced as a
hard limit.

=item *

C<IncreaseMaxCapacity> - Amazon EC2 Auto Scaling can scale out capacity
higher than the maximum capacity when the forecast capacity is close to
or exceeds the maximum capacity. The upper limit is determined by the
forecasted capacity and the value for C<MaxCapacityBuffer>.

=back



=head2 MaxCapacityBuffer => Int

The size of the capacity buffer to use when the forecast capacity is
close to or exceeds the maximum capacity. The value is specified as a
percentage relative to the forecast capacity. For example, if the
buffer is 10, this means a 10 percent buffer, such that if the forecast
capacity is 50, and the maximum capacity is 40, then the effective
maximum capacity is 55.

If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the
maximum capacity to equal but not exceed forecast capacity.

Required if the C<MaxCapacityBreachBehavior> property is set to
C<IncreaseMaxCapacity>, and cannot be used otherwise.


=head2 B<REQUIRED> MetricSpecifications => ArrayRef[L<Paws::AutoScaling::PredictiveScalingMetricSpecification>]

This structure includes the metrics and target utilization to use for
predictive scaling.

This is an array, but we currently only support a single metric
specification. That is, you can specify a target value and a single
metric pair, or a target value and one scaling metric and one load
metric.


=head2 Mode => Str

The predictive scaling mode. Defaults to C<ForecastOnly> if not
specified.


=head2 SchedulingBufferTime => Int

The amount of time, in seconds, by which the instance launch time can
be advanced. For example, the forecast says to add capacity at 10:00
AM, and you choose to pre-launch instances by 5 minutes. In that case,
the instances will be launched at 9:55 AM. The intention is to give
resources time to be provisioned. It can take a few minutes to launch
an EC2 instance. The actual amount of time required depends on several
factors, such as the size of the instance and whether there are startup
scripts to complete.

The value must be less than the forecast interval duration of 3600
seconds (60 minutes). Defaults to 300 seconds if not specified.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

