#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Geo::GeoNames;

my $g = Geo::GeoNames->new( username => 'fakeusername');

my $data = do { local $/; <DATA> };
ok eval { $g->_parse_json_result($data) }, 'Parsing JSON does not die';

is @{ $g->_parse_json_result($data)->{geonames} }, 24, 'Correct amount of entries';

done_testing;

__DATA__
{"totalResultsCount":24,"geonames":[{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"bbox":{"east":19.03998801122026,"south":69.6194123506006,"north":69.6783876493994,"west":18.870171988779738},"asciiName":"Tromso","countryId":"3144096","fcl":"P","score":48.84378433227539,"adminId2":"6453316","countryCode":"NO","adminId1":"3133897","lat":"69.6489","fcode":"PPLA","continentCode":"EU","adminCode2":"1902","adminCode1":"18","lng":"18.95508","geonameId":3133895,"toponymName":"Tromsø","population":52436,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Tromsīeg","lang":"ang"},{"name":"ترومسو","lang":"ar"},{"name":"Горад Тромсё","lang":"be"},{"name":"Тромсьо","lang":"bg"},{"name":"ট্রোমসা","lang":"bpy"},{"name":"Tromsø","lang":"ca"},{"name":"Tromsø","lang":"cs"},{"name":"Tromsø","lang":"da"},{"name":"Tromsø","lang":"de"},{"name":"Tromsø","lang":"en"},{"name":"Tromsø","lang":"eo"},{"name":"Tromsø","lang":"es"},{"name":"Tromsø","lang":"et"},{"name":"ترومسا","lang":"fa"},{"name":"Tromssa","lang":"fi"},{"name":"Tromsø","lang":"fr"},{"name":"טרומסה","lang":"he"},{"name":"Tromsø","lang":"hu"},{"name":"TOS","lang":"iata"},{"name":"Tromsø","lang":"id"},{"name":"Tromsø","lang":"it"},{"name":"トロムソ","lang":"ja"},{"name":"ტრომსე","lang":"ka"},{"name":"트롬쇠","lang":"ko"},{"name":"Tromsonda","lang":"la"},{"name":"Tromsø","lang":"lb"},{"name":"http://en.wikipedia.org/wiki/Troms%C3%B8","lang":"link"},{"name":"Trumsė","lang":"lt"},{"name":"Trumse","lang":"lv"},{"name":"Тромсе","lang":"mk"},{"name":"ट्रोम्सो","lang":"mr"},{"name":"Kommun Tromsø","lang":"nds"},{"name":"Tromsø","lang":"nl"},{"name":"Tromsø kommune","lang":"nn"},{"name":"Tromsø","lang":"no"},{"name":"Тромсё","lang":"os"},{"name":"Tromsø","lang":"pl"},{"name":"ٹرومسو","lang":"pnb"},{"name":"Tromsø","lang":"pt"},{"name":"Тромсё","lang":"ru"},{"name":"Romsa","lang":"se"},{"name":"Тромсе","lang":"sr"},{"name":"Tromsö kommun","lang":"sv"},{"name":"ทรมเซอ","lang":"th"},{"name":"Tromso","lang":"tr"},{"name":"Тромсе","lang":"uk"},{"name":"TOS","lang":"unlc"},{"name":"特罗姆瑟","lang":"zh"}],"adminName2":"Tromsø","name":"Romsa","fclName":"city, village,...","countryName":"Norway","fcodeName":"seat of a first-order administrative division","adminName1":"Troms"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"bbox":{"east":22.85832977294922,"south":68.33665466308594,"north":70.28776550292969,"west":15.606109619140625},"asciiName":"Troms Fylke","countryId":"3144096","fcl":"A","score":24.457590103149414,"countryCode":"NO","adminId1":"3133897","lat":"69.6442","fcode":"ADM1","continentCode":"EU","adminCode1":"18","lng":"18.9445","geonameId":3133897,"toponymName":"Troms Fylke","adminTypeName":"county","population":152741,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"http://en.wikipedia.org/wiki/Troms","lang":"link"},{"name":"Romsa","lang":"se"}],"adminName2":"","name":"Romsa","fclName":"country, state, region,...","countryName":"Norway","fcodeName":"first-order administrative division","adminName1":"Troms"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Vienna","dstOffset":2},"bbox":{"east":13.66874265313723,"south":47.41250273752136,"north":47.43049003502487,"west":13.642153266662575},"asciiName":"Ramsau am Dachstein","countryId":"2782113","fcl":"P","score":20.973848342895508,"cc2":"AT","adminId2":"2772479","adminId3":"2767993","countryCode":"AT","adminId1":"2764581","lat":"47.4215","fcode":"PPL","continentCode":"EU","adminCode2":"612","adminCode3":"61236","adminCode1":"06","lng":"13.65545","geonameId":2768006,"toponymName":"Ramsau am Dachstein","population":0,"adminName5":"","adminName4":"","adminName3":"Gemeinde Ramsau am Dachstein","alternateNames":[{"name":"Romsau am Dochstoa","lang":"bar"},{"name":"Ramsau","lang":"de"},{"name":"Рамзау-ам-Дахштайн","lang":"kk"},{"name":"http://en.wikipedia.org/wiki/Ramsau_am_Dachstein","lang":"link"},{"name":"Пайтинг","lang":"ru"},{"name":"达赫施泰因山麓拉姆绍","lang":"zh"}],"adminName2":"Politischer Bezirk Liezen","name":"Romsau am Dochstoa","fclName":"city, village,...","countryName":"Austria","fcodeName":"populated place","adminName1":"Styria"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"bbox":{"east":10.905368492015972,"south":59.9631855040223,"north":59.97038042302318,"west":10.890991523853168},"asciiName":"Romsas","countryId":"3144096","fcl":"P","score":17.4901065826416,"adminId2":"6453366","countryCode":"NO","adminId1":"3143242","lat":"59.96678","fcode":"PPLX","continentCode":"EU","adminCode2":"0301","adminCode1":"12","lng":"10.89818","geonameId":8125791,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"http://en.wikipedia.org/wiki/Roms%C3%A5s","lang":"link"}],"adminName2":"Oslo","name":"Romsås","fclName":"city, village,...","countryName":"Norway","fcodeName":"section of populated place","adminName1":"Oslo"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Ramsavarri","countryId":"3144096","fcl":"T","score":14.006363868713379,"adminId2":"779327","countryCode":"NO","adminId1":"780166","lat":"68.83052","fcode":"HLL","continentCode":"EU","adminCode2":"2011","adminCode1":"05","lng":"22.59003","geonameId":778184,"toponymName":"Råmsavarri","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsavárri","lang":"se"}],"adminName2":"Kautokeino","name":"Romsavarre","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"hill","adminName1":"Finnmark Fylke"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsa","countryId":"3144096","fcl":"T","score":14.006363868713379,"adminId2":"6453371","countryCode":"NO","adminId1":"3141558","lat":"59.67694","fcode":"ISL","continentCode":"EU","adminCode2":"1160","adminCode1":"14","lng":"5.73833","geonameId":3141417,"toponymName":"Romsa","population":0,"adminName5":"","adminName4":"","adminName3":"","adminName2":"Vindafjord","name":"Romsa","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"island","adminName1":"Rogaland"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsas","countryId":"3144096","fcl":"T","score":14.006363868713379,"adminId2":"3146936","countryCode":"NO","adminId1":"3163480","lat":"59.86921","fcode":"HLL","continentCode":"EU","adminCode2":"0230","adminCode1":"01","lng":"10.97586","geonameId":9216599,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsås","lang":"no"}],"adminName2":"Lørenskog","name":"Romsas","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"hill","adminName1":"Akershus"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsas","countryId":"3144096","fcl":"T","score":14.006363868713379,"adminId2":"3158629","countryCode":"NO","adminId1":"3153403","lat":"59.92812","fcode":"HLL","continentCode":"EU","adminCode2":"0420","adminCode1":"06","lng":"12.16896","geonameId":9372849,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsås","lang":"no"}],"adminName2":"Eidskog","name":"Romsas","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"hill","adminName1":"Hedmark"},{"timezone":{"gmtOffset":2,"timeZoneId":"Europe/Helsinki","dstOffset":3},"bbox":{"east":23.781140783404634,"south":60.149565532567756,"north":60.16755283007061,"west":23.74498288651954},"asciiName":"Romsarby","countryId":"660013","fcl":"P","score":12.264492988586426,"adminId2":"9610695","adminId3":"8128754","countryCode":"FI","adminId1":"830709","lat":"60.15856","fcode":"PPL","continentCode":"EU","adminCode2":"014","adminCode3":"710","adminCode1":"01","lng":"23.76306","geonameId":639056,"toponymName":"Romsarby","population":0,"adminName5":"","adminName4":"","adminName3":"Raseborg","adminName2":"Raaseporin","name":"Romsarby","fclName":"city, village,...","countryName":"Finland","fcodeName":"populated place","adminName1":"Uusimaa"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsasen","countryId":"3144096","fcl":"T","score":10.522622108459473,"adminId2":"3154388","countryCode":"NO","adminId1":"3132064","lat":"58.38382","fcode":"HLL","continentCode":"EU","adminCode2":"1034","adminCode1":"19","lng":"7.26326","geonameId":9227565,"toponymName":"Romsåsen","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsåsen","lang":"no"}],"adminName2":"Hægebostad","name":"Romsasen","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"hill","adminName1":"Vest-Agder"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsasen","countryId":"3144096","fcl":"T","score":10.522622108459473,"adminId2":"3162649","countryCode":"NO","adminId1":"3143188","lat":"59.58813","fcode":"HLL","continentCode":"EU","adminCode2":"0124","adminCode1":"13","lng":"11.10929","geonameId":9215663,"toponymName":"Romsåsen","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsåsen","lang":"no"}],"adminName2":"Askim","name":"Romsasen","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"hill","adminName1":"Østfold"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsasen","countryId":"3144096","fcl":"T","score":10.522622108459473,"adminId2":"6453369","countryCode":"NO","adminId1":"3134723","lat":"59.67743","fcode":"HLL","continentCode":"EU","adminCode2":"0807","adminCode1":"17","lng":"9.04831","geonameId":9248366,"toponymName":"Romsåsen","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsåsen","lang":"no"}],"adminName2":"Notodden","name":"Romsasen","fclName":"mountain,hill,rock,... ","countryName":"Norway","fcodeName":"hill","adminName1":"Telemark"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Stockholm","dstOffset":2},"bbox":{"east":13.250222870025745,"south":57.80767305124857,"north":57.82566034875143,"west":13.216443729974255},"asciiName":"Romsas","countryId":"2661886","fcl":"P","score":10.522622108459473,"adminId2":"2666492","countryCode":"SE","adminId1":"3337386","lat":"57.81667","fcode":"PPL","continentCode":"EU","adminCode2":"1491","adminCode1":"28","lng":"13.23333","geonameId":2681891,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","adminName2":"Ulricehamn Municipality","name":"Romsås","fclName":"city, village,...","countryName":"Sweden","fcodeName":"populated place","adminName1":"Västra Götaland"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsasundet","countryId":"3144096","fcl":"H","score":8.78075122833252,"cc2":"NO","countryCode":"NO","adminId1":"3151864","lat":"59.67194","fcode":"CHNM","continentCode":"EU","adminCode1":"07","lng":"5.77417","geonameId":3205941,"toponymName":"Romsasundet","population":0,"adminName5":"","adminName4":"","adminName3":"","adminName2":"","name":"Romsasundet","fclName":"stream, lake, ...","countryName":"Norway","fcodeName":"marine channel","adminName1":"Hordaland"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsa","countryId":"3144096","fcl":"H","score":6.16794490814209,"adminId2":"6453371","countryCode":"NO","adminId1":"3141558","lat":"59.67506","fcode":"INLT","continentCode":"EU","adminCode2":"1160","adminCode1":"14","lng":"5.73968","geonameId":9608834,"toponymName":"Romsa","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsa","lang":"no"}],"adminName2":"Vindafjord","name":"Romsa","fclName":"stream, lake, ...","countryName":"Norway","fcodeName":"inlet","adminName1":"Rogaland"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsas","countryId":"3144096","fcl":"S","score":5.297009468078613,"adminId2":"3141849","countryCode":"NO","adminId1":"3143487","lat":"61.46813","fcode":"FRM","continentCode":"EU","adminCode2":"0520","adminCode1":"11","lng":"10.22564","geonameId":9822673,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsås","lang":"no"}],"adminName2":"Ringebu","name":"Romsas","fclName":"spot, building, farm","countryName":"Norway","fcodeName":"farm","adminName1":"Oppland"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsas","countryId":"3144096","fcl":"S","score":5.297009468078613,"adminId2":"3141849","countryCode":"NO","adminId1":"3143487","lat":"61.46578","fcode":"FRM","continentCode":"EU","adminCode2":"0520","adminCode1":"11","lng":"10.37869","geonameId":9841695,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsås","lang":"no"}],"adminName2":"Ringebu","name":"Romsas","fclName":"spot, building, farm","countryName":"Norway","fcodeName":"farm","adminName1":"Oppland"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsas","countryId":"3144096","fcl":"S","score":4.426074028015137,"adminId2":"3137167","countryCode":"NO","adminId1":"3153403","lat":"60.72188","fcode":"FRM","continentCode":"EU","adminCode2":"0417","adminCode1":"06","lng":"11.32469","geonameId":9477998,"toponymName":"Romsås","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsås","lang":"no"}],"adminName2":"Stange","name":"Romsas","fclName":"spot, building, farm","countryName":"Norway","fcodeName":"farm","adminName1":"Hedmark"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsaetra","countryId":"3144096","fcl":"S","score":4.426074028015137,"adminId2":"3137167","countryCode":"NO","adminId1":"3153403","lat":"60.52635","fcode":"FRM","continentCode":"EU","adminCode2":"0417","adminCode1":"06","lng":"11.30864","geonameId":9830259,"toponymName":"Romsætra","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsætra","lang":"no"}],"adminName2":"Stange","name":"Romsaetra","fclName":"spot, building, farm","countryName":"Norway","fcodeName":"farm","adminName1":"Hedmark"},{"timezone":{"gmtOffset":-7,"timeZoneId":"America/Denver","dstOffset":-6},"asciiName":"Romsa Ranch","countryId":"6252001","fcl":"S","score":4.426074028015137,"adminId2":"5830051","countryCode":"US","adminId1":"5843591","lat":"41.2147","continentCode":"NA","elevation":2053,"adminCode2":"021","adminCode1":"WY","lng":"-105.04081","geonameId":5836998,"toponymName":"Romsa Ranch","population":0,"adminName5":"","adminName4":"","adminName3":"","adminName2":"Laramie County","name":"Romsa Ranch","fclName":"spot, building, farm","countryName":"United States","fcodeName":"","adminName1":"Wyoming"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsas kirke","countryId":"3144096","fcl":"S","score":4.426074028015137,"adminId2":"6453366","countryCode":"NO","adminId1":"3143242","lat":"59.96929","fcode":"CH","continentCode":"EU","adminCode2":"0301","adminCode1":"12","lng":"10.89039","geonameId":8533029,"toponymName":"Romsås kirke","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsås kirke","lang":"no"}],"adminName2":"Oslo","name":"Romsas kirke","fclName":"spot, building, farm","countryName":"Norway","fcodeName":"church","adminName1":"Oslo"},{"timezone":{"gmtOffset":-7,"timeZoneId":"America/Denver","dstOffset":-6},"asciiName":"Romsa Dolomite Deposit","countryId":"6252001","fcl":"S","score":4.426074028015137,"adminId2":"5835308","countryCode":"US","adminId1":"5843591","lat":"41.90472","fcode":"MN","continentCode":"NA","elevation":1802,"adminCode2":"031","adminCode1":"WY","lng":"-105.25667","geonameId":6333083,"toponymName":"Romsa Dolomite Deposit","population":0,"adminName5":"","adminName4":"","adminName3":"","adminName2":"Platte County","name":"Romsa Dolomite Deposit","fclName":"spot, building, farm","countryName":"United States","fcodeName":"mine(s)","adminName1":"Wyoming"},{"adminCode1":"14","lng":"5.6","geonameId":3230307,"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"toponymName":"Romsalandsvågen","asciiName":"Romsalandsvagen","countryId":"3144096","fcl":"H","population":0,"adminName5":"","adminName4":"","score":3.555138111114502,"adminName3":"","adminName2":"","countryCode":"NO","name":"Romsalandsvågen","fclName":"stream, lake, ...","countryName":"Norway","fcodeName":"cove(s)","adminId1":"3141558","adminName1":"Rogaland","lat":"59.41667","fcode":"COVE","continentCode":"EU"},{"timezone":{"gmtOffset":1,"timeZoneId":"Europe/Oslo","dstOffset":2},"asciiName":"Romsaeterbekken","countryId":"3144096","fcl":"H","score":3.555138111114502,"adminId2":"3137167","countryCode":"NO","adminId1":"3153403","lat":"60.5124","fcode":"STM","continentCode":"EU","adminCode2":"0417","adminCode1":"06","lng":"11.32389","geonameId":9788328,"toponymName":"Romsæterbekken","population":0,"adminName5":"","adminName4":"","adminName3":"","alternateNames":[{"name":"Romsæterbekken","lang":"no"}],"adminName2":"Stange","name":"Romsaeterbekken","fclName":"stream, lake, ...","countryName":"Norway","fcodeName":"stream","adminName1":"Hedmark"}]}
