package WordList::EN::Oxford3000::Learner;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-23'; # DATE
our $DIST = 'WordList-EN-Oxford3000-Learner'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words",2973,"num_words_contains_whitespace",0,"num_words_contain_unicode",0,"num_words_contains_nonword_chars",4,"avg_word_len",6.29902455432223,"longest_word_len",14,"num_words_contain_whitespace",0,"num_words_contain_nonword_chars",4,"num_words_contains_unicode",0,"shortest_word_len",1); # STATS

1;
# ABSTRACT: The most important words to learn in English

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::Oxford3000::Learner - The most important words to learn in English

=head1 VERSION

This document describes version 0.001 of WordList::EN::Oxford3000::Learner (from Perl distribution WordList-EN-Oxford3000-Learner), released on 2020-05-23.

=head1 SYNOPSIS

 use WordList::EN::Oxford3000::Learner;

 my $wl = WordList::EN::Oxford3000::Learner->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Source: L<https://www.oxfordlearnersdictionaries.com/wordlists/oxford3000-5000>

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 6.29902455432223 |
 | longest_word_len                 | 14               |
 | num_words                        | 2973             |
 | num_words_contain_nonword_chars  | 4                |
 | num_words_contain_unicode        | 0                |
 | num_words_contain_whitespace     | 0                |
 | num_words_contains_nonword_chars | 4                |
 | num_words_contains_unicode       | 0                |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 1                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-EN-Oxford3000-Learner>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-EN-Oxford3000-Learner>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-EN-Oxford3000-Learner>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

Other C<WordList::EN::Oxford3000::*> modules, e.g.
L<WordList::EN::Oxford3000::AdvancedAmerican>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
April
August
CD
DVD
December
February
Friday
I
IT
January
July
June
March
May
Monday
November
OK
October
Saturday
September
Sunday
T-shirt
TV
Thursday
Tuesday
Wednesday
a
abandon
ability
able
about
above
abroad
absolute
absolutely
academic
accept
acceptable
access
accident
accommodation
accompany
according
account
accurate
accuse
achieve
achievement
acknowledge
acquire
across
act
action
active
activity
actor
actress
actual
actually
ad
adapt
add
addition
additional
address
administration
admire
admit
adopt
adult
advance
advanced
advantage
adventure
advertise
advertisement
advertising
advice
advise
affair
affect
afford
afraid
after
afternoon
afterwards
again
against
age
aged
agency
agenda
agent
aggressive
ago
agree
agreement
ah
ahead
aid
aim
air
aircraft
airline
airport
alarm
album
alcohol
alcoholic
alive
all
allow
almost
alone
along
already
also
alter
alternative
although
always
amazed
amazing
ambition
ambitious
among
amount
analyse
analysis
ancient
and
anger
angle
angry
animal
ankle
anniversary
announce
announcement
annoy
annoyed
annoying
annual
another
answer
anxious
any
anybody
anyone
anything
anyway
anywhere
apart
apartment
apologize
app
apparent
apparently
appeal
appear
appearance
apple
application
apply
appointment
appreciate
approach
appropriate
approval
approve
approximately
architect
architecture
area
argue
argument
arise
arm
armed
arms
army
around
arrange
arrangement
arrest
arrival
arrive
art
article
artificial
artist
artistic
as
ashamed
ask
asleep
aspect
assess
assessment
assignment
assist
assistant
associate
associated
association
assume
at
athlete
atmosphere
attach
attack
attempt
attend
attention
attitude
attract
attraction
attractive
audience
aunt
author
authority
autumn
available
average
avoid
award
aware
away
awful
baby
back
background
backwards
bacteria
bad
badly
bag
bake
balance
ball
ban
banana
band
bank
bar
barrier
base
baseball
based
basic
basically
basis
basketball
bath
bathroom
battery
battle
be
beach
bean
bear
beat
beautiful
beauty
because
become
bed
bedroom
bee
beef
beer
before
beg
begin
beginning
behave
behaviour
behind
being
belief
believe
bell
belong
below
belt
bend
benefit
bent
best
bet
better
between
beyond
bicycle
big
bike
bill
billion
bin
biology
bird
birth
birthday
biscuit
bit
bite
bitter
black
blame
blank
blind
block
blog
blonde
blood
blow
blue
board
boat
body
boil
bomb
bond
bone
book
boot
border
bored
boring
born
borrow
boss
both
bother
bottle
bottom
bowl
box
boy
boyfriend
brain
branch
brand
brave
bread
break
breakfast
breast
breath
breathe
breathing
bride
bridge
brief
bright
brilliant
bring
broad
broadcast
broken
brother
brown
brush
bubble
budget
build
building
bullet
bunch
burn
bury
bus
bush
business
businessman
busy
but
butter
button
buy
by
bye
cable
cafe
cake
calculate
call
calm
camera
camp
campaign
camping
campus
can
cancel
cancer
candidate
cannot
cap
capable
capacity
capital
captain
capture
car
card
care
career
careful
carefully
careless
carpet
carrot
carry
cartoon
case
cash
cast
castle
cat
catch
category
cause
ceiling
celebrate
celebration
celebrity
cell
cent
central
centre
century
ceremony
certain
certainly
chain
chair
chairman
challenge
champion
chance
change
channel
chapter
character
characteristic
charge
charity
chart
chat
cheap
cheat
check
cheerful
cheese
chef
chemical
chemistry
chest
chicken
chief
child
childhood
chip
chocolate
choice
choose
church
cigarette
cinema
circle
circumstance
cite
citizen
city
civil
claim
class
classic
classical
classroom
clause
clean
clear
clearly
clever
click
client
climate
climb
clock
close
closed
closely
cloth
clothes
clothing
cloud
club
clue
coach
coal
coast
coat
code
coffee
coin
cold
collapse
colleague
collect
collection
college
colour
coloured
column
combination
combine
come
comedy
comfort
comfortable
command
comment
commercial
commission
commit
commitment
committee
common
commonly
communicate
communication
community
company
compare
comparison
compete
competition
competitive
competitor
complain
complaint
complete
completely
complex
complicated
component
computer
concentrate
concentration
concept
concern
concerned
concert
conclude
conclusion
condition
conduct
conference
confidence
confident
confirm
conflict
confuse
confused
confusing
connect
connected
connection
conscious
consequence
conservative
consider
consideration
consist
consistent
constant
constantly
construct
construction
consume
consumer
contact
contain
container
contemporary
content
contest
context
continent
continue
continuous
contract
contrast
contribute
contribution
control
convenient
conversation
convert
convince
convinced
cook
cooker
cooking
cool
copy
core
corner
corporate
correct
correctly
cost
costume
cottage
cotton
could
council
count
country
countryside
county
couple
courage
course
court
cousin
cover
covered
cow
crash
crazy
cream
create
creation
creative
creature
credit
crew
crime
criminal
crisis
criterion
critic
critical
criticism
criticize
crop
cross
crowd
crowded
crucial
cruel
cry
cultural
culture
cup
cupboard
cure
curly
currency
current
currently
curtain
curve
curved
custom
customer
cut
cycle
dad
daily
damage
dance
dancer
dancing
danger
dangerous
dark
data
date
daughter
day
dead
deal
dear
death
debate
debt
decade
decent
decide
decision
declare
decline
decorate
decoration
decrease
deep
deeply
defeat
defence
defend
define
definite
definitely
definition
degree
delay
deliberate
deliberately
delicious
delight
delighted
deliver
delivery
demand
demonstrate
dentist
deny
department
departure
depend
depressed
depressing
depth
describe
description
desert
deserve
design
designer
desire
desk
desperate
despite
destination
destroy
detail
detailed
detect
detective
determine
determined
develop
development
device
diagram
dialogue
diamond
diary
dictionary
die
diet
difference
different
differently
difficult
difficulty
dig
digital
dinner
direct
direction
directly
director
dirt
dirty
disadvantage
disagree
disappear
disappointed
disappointing
disaster
disc
discipline
discount
discover
discovery
discuss
discussion
disease
dish
dishonest
disk
dislike
dismiss
display
distance
distribute
distribution
district
divide
division
divorced
do
doctor
document
documentary
dog
dollar
domestic
dominate
donate
door
double
doubt
down
download
downstairs
downwards
dozen
draft
drag
drama
dramatic
draw
drawing
dream
dress
dressed
drink
drive
driver
driving
drop
drug
drum
drunk
dry
due
during
dust
duty
each
ear
early
earn
earth
earthquake
easily
east
eastern
easy
eat
economic
economy
edge
edit
edition
editor
educate
educated
education
educational
effect
effective
effectively
efficient
effort
egg
eight
eighteen
eighty
either
elderly
elect
election
electric
electrical
electricity
electronic
element
elephant
eleven
else
elsewhere
email
embarrassed
embarrassing
emerge
emergency
emotion
emotional
emphasis
emphasize
employ
employee
employer
employment
empty
enable
encounter
encourage
end
ending
enemy
energy
engage
engaged
engine
engineer
engineering
enhance
enjoy
enormous
enough
enquiry
ensure
enter
entertain
entertainment
enthusiasm
enthusiastic
entire
entirely
entrance
entry
environment
environmental
episode
equal
equally
equipment
error
escape
especially
essay
essential
establish
estate
estimate
ethical
euro
evaluate
even
evening
event
eventually
ever
every
everybody
everyday
everyone
everything
everywhere
evidence
evil
exact
exactly
exam
examination
examine
example
excellent
except
exchange
excited
excitement
exciting
excuse
executive
exercise
exhibition
exist
existence
expand
expect
expectation
expected
expedition
expense
expensive
experience
experienced
experiment
expert
explain
explanation
explode
exploration
explore
explosion
export
expose
express
expression
extend
extent
external
extra
extraordinary
extreme
extremely
eye
face
facility
fact
factor
factory
fail
failure
fair
fairly
faith
fall
false
familiar
family
famous
fan
fancy
fantastic
far
farm
farmer
farming
fascinating
fashion
fashionable
fast
fasten
fat
father
fault
favour
favourite
fear
feather
feature
fee
feed
feedback
feel
feeling
fellow
female
fence
festival
few
fiction
field
fifteen
fifth
fifty
fight
fighting
figure
file
fill
film
final
finally
finance
financial
find
finding
fine
finger
finish
fire
firm
first
firstly
fish
fishing
fit
fitness
five
fix
fixed
flag
flame
flash
flat
flexible
flight
float
flood
floor
flour
flow
flower
flu
fly
flying
focus
fold
folding
folk
follow
following
food
foot
football
for
force
foreign
forest
forever
forget
forgive
fork
form
formal
former
fortunately
fortune
forty
forward
found
four
fourteen
fourth
frame
free
freedom
freeze
frequency
frequently
fresh
fridge
friend
friendly
friendship
frighten
frightened
frightening
frog
from
front
frozen
fruit
fry
fuel
full
fully
fun
function
fund
fundamental
funding
funny
fur
furniture
further
furthermore
future
gain
gallery
game
gang
gap
garage
garden
gas
gate
gather
general
generally
generate
generation
generous
genre
gentle
gentleman
geography
get
ghost
giant
gift
girl
girlfriend
give
glad
glass
global
glove
go
goal
god
gold
golf
good
goodbye
goods
govern
government
grab
grade
gradually
graduate
grain
grand
grandfather
grandmother
grandparent
grant
grass
grateful
great
green
greet
grey
ground
group
grow
growth
guarantee
guard
guess
guest
guide
guilty
guitar
gun
guy
gym
habit
hair
half
hall
hand
handle
hang
happen
happily
happiness
happy
hard
hardly
harm
harmful
hat
hate
have
he
head
headache
headline
health
healthy
hear
hearing
heart
heat
heating
heaven
heavily
heavy
heel
height
helicopter
hell
hello
help
helpful
her
here
hero
hers
herself
hesitate
hey
hi
hide
high
highlight
highly
hill
him
himself
hire
his
historic
historical
history
hit
hobby
hockey
hold
hole
holiday
hollow
holy
home
homework
honest
honour
hope
horrible
horror
horse
hospital
host
hot
hotel
hour
house
household
housing
how
however
huge
human
humorous
humour
hundred
hungry
hunt
hunting
hurricane
hurry
hurt
husband
ice
idea
ideal
identify
identity
if
ignore
ill
illegal
illness
illustrate
illustration
image
imaginary
imagination
imagine
immediate
immediately
immigrant
impact
impatient
imply
import
importance
important
impose
impossible
impress
impressed
impression
impressive
improve
improvement
in
inch
incident
include
included
including
income
increase
increasingly
incredible
incredibly
indeed
independent
indicate
indirect
individual
indoor
indoors
industrial
industry
infection
influence
inform
informal
information
ingredient
initial
initially
initiative
injure
injured
injury
inner
innocent
inquiry
insect
inside
insight
insist
inspire
install
instance
instead
institute
institution
instruction
instructor
instrument
insurance
intelligence
intelligent
intend
intended
intense
intention
interest
interested
interesting
internal
international
internet
interpret
interrupt
interview
into
introduce
introduction
invent
invention
invest
investigate
investigation
investment
invitation
invite
involve
involved
iron
island
issue
it
item
its
itself
jacket
jam
jazz
jeans
jewellery
job
join
joke
journal
journalist
journey
joy
judge
judgement
juice
jump
junior
just
justice
justify
keen
keep
key
keyboard
kick
kid
kill
killing
kilometre
kind
king
kiss
kitchen
knee
knife
knock
know
knowledge
lab
label
laboratory
labour
lack
lady
lake
lamp
land
landscape
language
laptop
large
largely
last
late
later
latest
laugh
laughter
launch
law
lawyer
lay
layer
lazy
lead
leader
leadership
leading
leaf
league
lean
learn
learning
least
leather
leave
lecture
left
leg
legal
leisure
lemon
lend
length
less
lesson
let
letter
level
library
licence
lie
life
lifestyle
lift
light
like
likely
limit
limited
line
link
lion
lip
liquid
list
listen
listener
literature
little
live
lively
living
load
loan
local
locate
located
location
lock
logical
lonely
long
long-term
look
loose
lord
lorry
lose
loss
lost
lot
loud
loudly
love
lovely
low
lower
luck
lucky
lunch
lung
luxury
machine
mad
magazine
magic
mail
main
mainly
maintain
major
majority
make
male
mall
man
manage
management
manager
manner
many
map
mark
market
marketing
marriage
married
marry
mass
massive
master
match
matching
material
mathematics
maths
matter
maximum
may
maybe
me
meal
mean
meaning
means
meanwhile
measure
measurement
meat
media
medical
medicine
medium
meet
meeting
melt
member
memory
mental
mention
menu
mess
message
metal
method
metre
middle
midnight
might
mild
mile
military
milk
million
mind
mine
mineral
minimum
minister
minor
minority
minute
mirror
miss
missing
mission
mistake
mix
mixed
mixture
mobile
model
modern
modify
moment
money
monitor
monkey
month
mood
moon
moral
more
morning
most
mostly
mother
motor
motorcycle
mount
mountain
mouse
mouth
move
movement
movie
much
mud
multiple
multiply
mum
murder
muscle
museum
music
musical
musician
must
my
myself
mysterious
mystery
nail
name
narrative
narrow
nation
national
native
natural
naturally
nature
near
nearly
neat
necessarily
necessary
neck
need
needle
negative
neighbour
neighbourhood
neither
nerve
nervous
net
network
never
nevertheless
new
news
newspaper
next
nice
night
nightmare
nine
nineteen
ninety
no
nobody
noise
noisy
none
nor
normal
normally
north
northern
nose
not
note
nothing
notice
notion
novel
now
nowhere
nuclear
number
numerous
nurse
nut
o'clock
obey
object
objective
obligation
observation
observe
obtain
obvious
obviously
occasion
occasionally
occur
ocean
odd
of
off
offence
offend
offensive
offer
office
officer
official
often
oh
oil
old
old-fashioned
on
once
one
onion
online
only
onto
open
opening
operate
operation
opinion
opponent
opportunity
oppose
opposed
opposite
opposition
option
or
orange
order
ordinary
organ
organization
organize
organized
organizer
origin
original
originally
other
otherwise
ought
our
ours
ourselves
out
outcome
outdoor
outdoors
outer
outline
outside
oven
over
overall
owe
own
owner
pace
pack
package
page
pain
painful
paint
painter
painting
pair
palace
pale
pan
panel
pants
paper
paragraph
parent
park
parking
parliament
part
participant
participate
particular
particularly
partly
partner
party
pass
passage
passenger
passion
passport
past
path
patient
pattern
pay
payment
peace
peaceful
pen
pencil
penny
pension
people
pepper
per
percentage
perfect
perfectly
perform
performance
perhaps
period
permanent
permission
permit
person
personal
personality
personally
perspective
persuade
pet
petrol
phase
phenomenon
philosophy
phone
photo
photograph
photographer
photography
phrase
physical
physics
piano
pick
picture
piece
pig
pile
pilot
pin
pink
pipe
pitch
place
plain
plan
plane
planet
planning
plant
plastic
plate
platform
play
player
pleasant
please
pleased
pleasure
plenty
plot
plus
pocket
poem
poet
poetry
point
pointed
poison
poisonous
police
policeman
policy
polite
political
politician
politics
pollution
pool
poor
pop
popular
popularity
population
port
portrait
pose
position
positive
possess
possession
possibility
possible
possibly
post
poster
pot
potato
potential
pound
pour
poverty
powder
power
powerful
practical
practice
practise
praise
pray
prayer
predict
prediction
prefer
pregnant
preparation
prepare
prepared
presence
present
presentation
preserve
president
press
pressure
pretend
pretty
prevent
previous
previously
price
priest
primary
prime
prince
princess
principle
print
printer
printing
priority
prison
prisoner
privacy
private
prize
probably
problem
procedure
process
produce
producer
product
production
profession
professional
professor
profile
profit
program
programme
progress
project
promise
promote
pronounce
proof
proper
properly
property
proposal
propose
prospect
protect
protection
protest
proud
prove
provide
psychologist
psychology
pub
public
publication
publish
pull
punish
punishment
pupil
purchase
pure
purple
purpose
pursue
push
put
qualification
qualified
qualify
quality
quantity
quarter
queen
question
queue
quick
quickly
quiet
quietly
quit
quite
quotation
quote
race
racing
radio
railway
rain
raise
range
rank
rapid
rapidly
rare
rarely
rate
rather
raw
reach
react
reaction
read
reader
reading
ready
real
realistic
reality
realize
really
reason
reasonable
recall
receipt
receive
recent
recently
reception
recipe
recognize
recommend
recommendation
record
recording
recover
recycle
red
reduce
reduction
refer
reference
reflect
refuse
regard
region
regional
register
regret
regular
regularly
regulation
reject
relate
related
relation
relationship
relative
relatively
relax
relaxed
relaxing
release
relevant
reliable
relief
religion
religious
rely
remain
remark
remember
remind
remote
remove
rent
repair
repeat
repeated
replace
reply
report
reporter
represent
representative
reputation
request
require
requirement
rescue
research
researcher
reservation
reserve
resident
resist
resolve
resort
resource
respect
respond
response
responsibility
responsible
rest
restaurant
result
retain
retire
retired
return
reveal
review
revise
revolution
reward
rhythm
rice
rich
rid
ride
right
ring
rise
risk
river
road
robot
rock
role
roll
romantic
roof
room
root
rope
rough
round
route
routine
row
royal
rub
rubber
rubbish
rude
rugby
rule
run
runner
running
rural
rush
sad
sadly
safe
safety
sail
sailing
sailor
salad
salary
sale
salt
same
sample
sand
sandwich
satellite
satisfied
satisfy
sauce
save
saving
say
scale
scan
scared
scary
scene
schedule
scheme
school
science
scientific
scientist
score
scream
screen
script
sculpture
sea
search
season
seat
second
secondary
secondly
secret
secretary
section
sector
secure
security
see
seed
seek
seem
select
selection
self
sell
send
senior
sense
sensible
sensitive
sentence
separate
sequence
series
serious
seriously
servant
serve
service
session
set
setting
settle
seven
seventeen
seventy
several
severe
sex
sexual
shade
shadow
shake
shall
shallow
shame
shape
share
sharp
she
sheep
sheet
shelf
shell
shelter
shift
shine
shiny
ship
shirt
shock
shocked
shoe
shoot
shooting
shop
shopping
short
shot
should
shoulder
shout
show
shower
shut
shy
sick
side
sight
sign
signal
significant
significantly
silence
silent
silk
silly
silver
similar
similarity
similarly
simple
simply
since
sincere
sing
singer
singing
single
sink
sir
sister
sit
site
situation
six
sixteen
sixty
size
ski
skiing
skill
skin
skirt
sky
slave
sleep
slice
slide
slight
slightly
slip
slope
slow
slowly
small
smart
smartphone
smell
smile
smoke
smoking
smooth
snake
snow
so
soap
soccer
social
society
sock
soft
software
soil
solar
soldier
solid
solution
solve
some
somebody
someone
something
sometimes
somewhat
somewhere
son
song
soon
sorry
sort
soul
sound
soup
source
south
southern
space
speak
speaker
special
specialist
species
specific
specifically
speech
speed
spell
spelling
spend
spending
spicy
spider
spirit
spiritual
split
spoken
sponsor
spoon
sport
spot
spread
spring
square
stable
stadium
staff
stage
stair
stamp
stand
standard
star
stare
start
state
statement
station
statistic
statue
status
stay
steady
steal
steel
steep
step
stick
sticky
stiff
still
stock
stomach
stone
stop
store
storm
story
straight
strange
stranger
strategy
stream
street
strength
stress
stretch
strict
strike
string
strong
strongly
structure
struggle
student
studio
study
stuff
stupid
style
subject
submit
substance
succeed
success
successful
successfully
such
sudden
suddenly
suffer
sugar
suggest
suggestion
suit
suitable
sum
summarize
summary
summer
sun
supermarket
supply
support
supporter
suppose
sure
surely
surface
surgery
surprise
surprised
surprising
surround
surrounding
survey
survive
suspect
swear
sweater
sweep
sweet
swim
swimming
switch
symbol
sympathy
symptom
system
table
tablet
tail
take
tale
talent
talented
talk
tall
tank
tape
target
task
taste
tax
taxi
tea
teach
teacher
teaching
team
tear
technical
technique
technology
teenage
teenager
telephone
television
tell
temperature
temporary
ten
tend
tennis
tent
term
terrible
test
text
than
thank
thanks
that
the
theatre
their
theirs
them
theme
themselves
then
theory
therapy
there
therefore
they
thick
thief
thin
thing
think
thinking
third
thirsty
thirteen
thirty
this
though
thought
thousand
threat
threaten
three
throat
through
throughout
throw
thus
ticket
tidy
tie
tight
till
time
tin
tiny
tip
tired
title
to
today
toe
together
toilet
tomato
tomorrow
tone
tongue
tonight
too
tool
tooth
top
topic
total
totally
touch
tough
tour
tourism
tourist
towards
towel
tower
town
toy
track
trade
tradition
traditional
traffic
train
trainer
training
transfer
transform
transition
translate
translation
transport
travel
traveller
treat
treatment
tree
trend
trial
trick
trip
tropical
trouble
trousers
truck
true
truly
trust
truth
try
tube
tune
tunnel
turn
twelve
twenty
twice
twin
two
type
typical
typically
tyre
ugly
ultimately
umbrella
unable
uncle
uncomfortable
unconscious
under
underground
understand
understanding
underwear
unemployed
unemployment
unexpected
unfair
unfortunately
unhappy
uniform
union
unique
unit
united
universe
university
unknown
unless
unlike
unlikely
unnecessary
unpleasant
until
unusual
up
update
upon
upper
upset
upstairs
upwards
urban
urge
us
use
used
useful
user
usual
usually
vacation
valley
valuable
value
van
variety
various
vary
vast
vegetable
vehicle
venue
version
very
via
victim
victory
video
view
viewer
village
violence
violent
virtual
virus
vision
visit
visitor
visual
vital
vitamin
voice
volume
volunteer
vote
wage
wait
waiter
wake
walk
wall
want
war
warm
warn
warning
wash
washing
waste
watch
water
wave
way
we
weak
weakness
wealth
wealthy
weapon
wear
weather
web
website
wedding
week
weekend
weigh
weight
welcome
well
west
western
wet
what
whatever
wheel
when
whenever
where
whereas
wherever
whether
which
while
whisper
white
who
whole
whom
whose
why
wide
widely
wife
wild
wildlife
will
willing
win
wind
window
wine
wing
winner
winter
wire
wise
wish
with
within
without
witness
woman
wonder
wonderful
wood
wooden
wool
word
work
worker
working
world
worldwide
worried
worry
worse
worst
worth
would
wound
wow
wrap
write
writer
writing
written
wrong
yard
yeah
year
yellow
yes
yesterday
yet
you
young
your
yours
yourself
youth
zero
zone
