package DBIx::Model::DB;
use strict;
use warnings;
use Type::Tiny;
use Types::Standard qw/ArrayRef Int Str Undef/;
use DBIx::Model::Table;

our $VERSION = '0.0.1';

my $Table = Type::Tiny->new(
    name       => 'Table',
    constraint => sub { ref($_) eq 'table' },
    message    => sub { "$_ ain't a table" },
);

our $INLINE = {
    catalog => {
        is  => 'ro',
        isa => Str | Undef,
    },
    chains => {
        is  => 'rw',
        isa => Int,
    },
    _tables => {
        is      => 'ro',
        isa     => ArrayRef [$Table],
        default => sub { [] },
    },
    name => {
        is       => 'ro',
        isa      => Str,
        required => 1,
    },
    schema => {
        is  => 'ro',
        isa => Str | Undef,
    },
    table_types => {
        is  => 'ro',
        isa => Str,
    },
};

sub add_table {
    my $self  = shift;
    my $table = DBIx::Model::Table->new( @_, db => $self );
    push( @{ $self->_tables }, $table );
    return $table;
}

sub tables {
    my $self = shift;
    return @{ $self->_tables } if wantarray;
    return $self->_tables;
}

sub as_string {
    my $self = shift;
    my $str  = $self->name;

    foreach my $table ( $self->tables ) {
        $str .= "\n" . $table->as_string('  ');
    }

    return $str;
}

### DO NOT EDIT BELOW! (generated by Class::Inline v0.0.1)
#<<<
  require Carp;our@ATTRS_UNEX=(undef);sub new {my$class=shift;my$self={@_ ? @_
  > 1 ? @_ : %{$_[0]}: ()};map {local$Carp::CarpLevel=$Carp::CarpLevel + 1;
  Carp::croak("missing attribute DBIx::Model::DB::$_ is required")unless
  exists$self->{$_}}'name';if (@ATTRS_UNEX){map {local$Carp::CarpLevel=
  $Carp::CarpLevel + 1;Carp::carp("DBIx::Model::DB attribute '$_' unexpected")
  ;delete$self->{$_ }}sort grep {not exists$INLINE->{$_ }}keys %$self}else {
  @ATTRS_UNEX=map {delete$self->{$_ };$_}grep {not exists$INLINE->{$_ }}keys %
  $self}bless$self,ref$class || $class;map {$self->{$_ }=eval {$INLINE->{$_ }
  ->{'isa'}->($self->{$_ })};Carp::croak(
  qq{DBIx::Model::DB::$_ value invalid ($@)})if $@}grep {exists$self->{$_ }}
  '_tables','catalog','chains','name','schema','table_types';my@check=(
  'DBIx::Model::DB');my@parents;while (@check){no strict 'refs';my$c=shift
  @check;push@parents,@{$c .'::ISA'};push@check,@{$c .'::ISA'}}map {$_->BUILD(
  )if exists &{$_.'::BUILD'}}reverse@parents;$self->BUILD()if exists &{'BUILD'
  };$self}sub __ro {my (undef,undef,undef,$sub)=caller(1);local
  $Carp::CarpLevel=$Carp::CarpLevel + 1;Carp::croak(
  "attribute $sub is read-only (value: '" .($_[1]// 'undef')."')")}sub _tables
  {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'_tables'}//= eval {$INLINE->{'_tables'}
  ->{'isa'}->($INLINE->{'_tables'}->{'default'}->($_[0]))};Carp::croak(
  'invalid (DBIx::Model::DB::_tables) default value: ' .$@)if $@;$_[0]{
  '_tables'}}sub catalog {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'catalog'}// undef
  }sub chains {if (@_ > 1){$_[0]{'chains'}=eval {$INLINE->{'chains'}->{'isa'}
  ->($_[1])};Carp::croak('invalid (DBIx::Model::DB::chains) value: '.$@)if $@;
  return $_[0]}$_[0]{'chains'}// undef}sub name {$_[0]->__ro($_[1])if @_ > 1;
  $_[0]{'name'}}sub schema {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'schema'}//
  undef}sub table_types {$_[0]->__ro($_[1])if @_ > 1;$_[0]{'table_types'}//
  undef}
#>>>
### DO NOT EDIT ABOVE! (generated by Class::Inline v0.0.1)

1;
