# Generated by default/object.tt
package Paws::SecurityHub::ClassificationResult;
  use Moose;
  has AdditionalOccurrences => (is => 'ro', isa => 'Bool');
  has CustomDataIdentifiers => (is => 'ro', isa => 'Paws::SecurityHub::CustomDataIdentifiersResult');
  has MimeType => (is => 'ro', isa => 'Str');
  has SensitiveData => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::SensitiveDataResult]');
  has SizeClassified => (is => 'ro', isa => 'Int');
  has Status => (is => 'ro', isa => 'Paws::SecurityHub::ClassificationStatus');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::ClassificationResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::ClassificationResult object:

  $service_obj->Method(Att1 => { AdditionalOccurrences => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::ClassificationResult object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalOccurrences

=head1 DESCRIPTION

Details about the sensitive data that was detected on the resource.

=head1 ATTRIBUTES


=head2 AdditionalOccurrences => Bool

Indicates whether there are additional occurrences of sensitive data
that are not included in the finding. This occurs when the number of
occurrences exceeds the maximum that can be included.


=head2 CustomDataIdentifiers => L<Paws::SecurityHub::CustomDataIdentifiersResult>

Provides details about sensitive data that was identified based on
customer-defined configuration.


=head2 MimeType => Str

The type of content that the finding applies to.


=head2 SensitiveData => ArrayRef[L<Paws::SecurityHub::SensitiveDataResult>]

Provides details about sensitive data that was identified based on
built-in configuration.


=head2 SizeClassified => Int

The total size in bytes of the affected data.


=head2 Status => L<Paws::SecurityHub::ClassificationStatus>

The current status of the sensitive data detection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

