# Generated by default/object.tt
package Paws::AmplifyBackend::BackendAPIResourceConfig;
  use Moose;
  has AdditionalAuthTypes => (is => 'ro', isa => 'ArrayRef[Paws::AmplifyBackend::BackendAPIAuthType]', request_name => 'additionalAuthTypes', traits => ['NameInRequest']);
  has ApiName => (is => 'ro', isa => 'Str', request_name => 'apiName', traits => ['NameInRequest']);
  has ConflictResolution => (is => 'ro', isa => 'Paws::AmplifyBackend::BackendAPIConflictResolution', request_name => 'conflictResolution', traits => ['NameInRequest']);
  has DefaultAuthType => (is => 'ro', isa => 'Paws::AmplifyBackend::BackendAPIAuthType', request_name => 'defaultAuthType', traits => ['NameInRequest']);
  has Service => (is => 'ro', isa => 'Str', request_name => 'service', traits => ['NameInRequest']);
  has TransformSchema => (is => 'ro', isa => 'Str', request_name => 'transformSchema', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::BackendAPIResourceConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::BackendAPIResourceConfig object:

  $service_obj->Method(Att1 => { AdditionalAuthTypes => $value, ..., TransformSchema => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::BackendAPIResourceConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalAuthTypes

=head1 DESCRIPTION

The resource config for the data model, configured as a part of the
Amplify project.

=head1 ATTRIBUTES


=head2 AdditionalAuthTypes => ArrayRef[L<Paws::AmplifyBackend::BackendAPIAuthType>]

Additional authentication methods used to interact with your data
models.


=head2 ApiName => Str

The API name used to interact with the data model, configured as a part
of the amplify project.


=head2 ConflictResolution => L<Paws::AmplifyBackend::BackendAPIConflictResolution>

The conflict resolution strategy for your data stored in the data
models.


=head2 DefaultAuthType => L<Paws::AmplifyBackend::BackendAPIAuthType>

The default authentication type for interacting with the configured
data models in your Amplify project.


=head2 Service => Str

The service used to provision and interact with the data model.


=head2 TransformSchema => Str

The definition of the data model in the annotated transform of the
GraphQL schema.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

