# Generated by default/object.tt
package Paws::AccessAnalyzer::Span;
  use Moose;
  has End => (is => 'ro', isa => 'Paws::AccessAnalyzer::Position', request_name => 'end', traits => ['NameInRequest'], required => 1);
  has Start => (is => 'ro', isa => 'Paws::AccessAnalyzer::Position', request_name => 'start', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::Span

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::Span object:

  $service_obj->Method(Att1 => { End => $value, ..., Start => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::Span object:

  $result = $service_obj->Method(...);
  $result->Att1->End

=head1 DESCRIPTION

A span in a policy. The span consists of a start position (inclusive)
and end position (exclusive).

=head1 ATTRIBUTES


=head2 B<REQUIRED> End => L<Paws::AccessAnalyzer::Position>

The end position of the span (exclusive).


=head2 B<REQUIRED> Start => L<Paws::AccessAnalyzer::Position>

The start position of the span (inclusive).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

