use Test::More;
use Syntax::Keyword::Combine::Keys qw/ckeys/;

my @keys = ckeys (
	a => 1,
	b => 2,
	c => 3,
	a => 4,
	b => 5,
	c => 6
);

is_deeply(\@keys, [qw/a b c/]);

my $first_hash = {
	a => 1,
	b => 2,
	c => 3
};

my %second_hash = (
	c => 3,
	d => 4,
	e => 5
);

@keys = ckeys %{$first_hash}, %second_hash;
is_deeply(\@keys, [qw/a b c d e/]);

done_testing;
