package Amazon::API::SecretsManager;

use strict;
use warnings;

use parent qw( Amazon::API );

our $VERSION = '1.3.2';

our @API_METHODS = qw{
  CancelRotateSecret
  CreateSecret
  DeleteResourcePolicy
  DeleteSecret
  DescribeSecret
  GetRandomPassword
  GetResourcePolicy
  GetSecretValue
  ListSecrets
  ListSecretVersionIds
  PutResourcePolicy
  PutSecretValue
  RemoveRegionsFromReplication
  ReplicateSecretToRegions
  RestoreSecret
  RotateSecret
  StopReplicationToReplica
  TagResource
  UntagResource
  UpdateSecret
  UpdateSecretVersionStage
  ValidateResourcePolicy
};

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref( $options[0] ) ? %{ $options[0] } : @options;

  my $self = $class->SUPER::new(
    { decode_always => 1,
      service       => 'secretsmanager',
      api           => 'secretsmanager',
      api_methods   => \@API_METHODS,
      %options
    },
  );

  return $self;
} ## end sub new

1;
