#=head1 NAME

Parse::Template - Processeur de templates contenant des expressions Perl (0.32)

#=head1 SYNOPSIS

  use Parse::Template;

  my %template = 
    (
     'TOP' =>  q!Text before %%$self->eval('DATA')%% text after!,
     'DATA' => q!Insert data: ! .
               q!1. List: %%"@list$N"%%! .
               q!2. Hash: %%"$hash{'key_value'}$N"%%! .
               q!3. File content: %%print <FH>%%! .
               q!4. Sub: %%&SUB()$N%%!
    );
 
  my $tmplt = new Parse::Template (%template);
  open FH, "< foo";

  $tmplt->env('var' => '(value!)');
  $tmplt->env('list' => [1, 2, 10], 
              'N' => "\n",
              'FH' => \*FH,
              'SUB' => sub { "->content generated by a sub<-" },
              'hash' => { 'key_value' => q!It\'s an hash value! });
  print $tmplt->eval('TOP'), "\n";

#=head1 DESCRIPTION

La classe C<Parse::Template> permet d'valuer des expressions Perl
places dans un texte.  Cette classe peut tre utilise comme
gnrateur de code, ou de documents appartenant  un format
documentaire quelconque (HTML, XML, RTF, etc.).

Le principe de la gnration de texte  partir d'un template est
simple.  Un template est constitu d'un texte qui comporte des
expressions  valuer en des endroits baliss. L'interprtation de ces
expressions gnre des fragments de textes qui viennent se substituer
aux expressions.

L'valuation a lieu dans un environnement dans lequel on peut, par
exemple, placer des structures de donnes qui serviront  gnrer les
parties  complter.


             TEMPLATE
          Texte + Expression Perl
		|
		+-----> Evaluation ----> Texte (document ou programme)
		|	
	   Subs + Structures de donnes
            ENVIRONNEMENT

La classe C<Parse::Template> permet de dcomposer un template en
parties.  Ces parties sont dfinies par un tableau associatif pass en
argument au constructeur de la classe :
C<Parse::Template->E<gt>C<new('someKey', '... text with expressions to
evaluate ...')>. Au sein d'une partie, l'inclusion d'une sous-partie
se fait au moyen d'une expression de la forme :

  $self->eval('SUB_PART_NAME')

C<$self> dsigne l'instance de la classe C<Parse::Template>. 

Vous pouvez vous contenter de ne mentionner que le nom de la
partie. Dans ce cas une routine du nom de cette partie est gnre
dynamiquement. Dans l'exemple du synopsis l'insertion de la partie
C<TOP> peut ainsi se rcrire comme suit :

  'TOP' => q!Text before %%DATA()%% text after!

C<DATA()> est place entre C<%%> et est de fait traiter comme une
expression a valuer. 

Les routines acceptent des arguments.  Un argument peut tre par
exemple utilis pour contrler la profondeur des appels rcursifs d'un
template :

  print Parse::Template->new(
	   'TOP' => q!%%$_[0] < 10 ? '[' . TOP($_[0] + 1) . ']' : ''%%!
	  )->eval('TOP', 0);


Dans une expression vous pouvez utiliser les variables C<$self> et
C<$part>. La premire dsigne l'instance template, la seconde le nom
de la partie dans laquelle se trouve l'expression.

La mthode C<env()> permet de construire l'environnement requis pour
l'valuation d'un template. Chaque entre  dfinir dans cet
environnement doit tre spcifie au moyen d'une cl du nom du symbole
 crer, associe  une rfrence dont le type est celui de l'entre 
crer dans cette environnement (par exemple, une rfrence  un
tableau pour crer un tableau).  Un variable scalaire est dfinie en
associant le nom de la variable  sa valeur.  Une variable scalaire
contenant une rfrence est dfinie en crivant
C<'var'=>E<gt>C<\$variable>, avec C<$variable> une variable  porte
lexicale qui contient la rfrence.

Chaque instance de C<Parse::Template> est dfinie dans une classe
spcifique, sous-classe de C<Parse::Template>. La sous-classe contient
l'environnement spcifique au template et hrite des mthodes de la
classe C<Parse::Template>.

En cas d'erreur de syntaxe dans l'valuation d'une expression
C<Parse::Template> essaie d'indiquer la partie du template et
l'expression  incriminer.  Si la variable
C<$Parse::Template::CONFESS> contient une valeur VRAIE la pile des
valuations est imprime.

#=head1 METHODES

#=over 4

#=item new HASH

Constructeur de la classe. C<HASH> est un tableau associatif qui
dfinit le texte du template.

Exemple.

	use Parse::Template;
	$t = new Parse::Template('key' => 'associated text');

#=item env HASH

#=item env SYMBOL

Permet de dfinir l'environnement spcifique  un template.

C<env(SYMBOL)> retourne la rfrence assoce au symbole ou C<undef> si
le symbole n'est pas dfini. La rfrence retourne est du type
indiqu par le caractre (C<&, $, %, @, *>) qui prfixe le symbole.

Exemples.

  $tmplt->env('LIST' => [1, 2, 3])}   Dfinition d'une liste

  @{$tmplt->env('*LIST')}             Retourne la liste

  @{$tmplt->env('@LIST')}             Idem


#=item eval PART_NAME

Evalue le partie du template dsigne par C<PART_NAME>. Retourne la
chane de caractres rsultant de cette valuation.

#=item getPart PART_NAME

Retourne la partie dsigne du template.

#=item ppregexp REGEXP

Pr-processe une expression rgulire de manire  pouvoir l'insrer
dans un template o le dlimiteur d'expression rgulire est un "/",
ou un "!".

#=item setPart PART_NAME => TEXT

C<setPart()> permet de dfinir une nouvelle entre dans le hash qui
dfinit le contenu du template.

#=back

#=head1 EXEMPLES


La classe C<Parse::Template> permet de se livrer  toutes sortes de
facties. En voici quelques illustrations.

Le premier exemple montre comment gnrer un document HTML en
exploitant une structure de donnes place dans l'environnement
d'valuation. Le template comporter deux partie C<DOC> et C<SECTION>.
La partie C<SECTION> est appele au sein de la partie C<DOC> pour
gnrer autant de sections qu'il y a d'lment dans le tableau
C<section_content>.

	my %template = ('DOC' => <<'END_OF_DOC;', 'SECTION' => <<'END_OF_SECTION;');
	<html>
	<head></head>
	<body>
	%%
	my $content;
	for (my $i = 0; $i <= $#section_content; $i++) {
	  $content .= SECTION($i);
	} 
	$content;
	%%
	</body>
	</html>
	END_OF_DOC;
	%%
	$section_content[$_[0]]->{Content} =~ s/^/<p>/mg;
	join '', '<H1>', $section_content[$_[0]]->{Title}, '</H1>', $section_content[$_[0]]->{Content};
	%%
	END_OF_SECTION;
	
	my $tmplt = new Parse::Template (%template);
	
	$tmplt->env('section_content' => [
				 {
				  Title => 'First Section', 
				  Content => 'Nothing to write'
				 }, 
				 {
				  Title => 'Second section', 
				  Content => 'Nothing else to write'
				 }
				]
		   );
	
	print $tmplt->eval('DOC'), "\n";

Le second exemple montre comment gnrer un document HTML  partir
d'une notation fonctionnelle, c'est--dire obtenir le texte :

	<P><B>text in bold</B><I>text in italic</I></P>

 partir de 

	P(B("text in bold"), I("text in italic"))


L'expression Perl permettant de produire ce genre de structure est
trs simple et se rduit  :
	
	join '', @_

Le contenu  valuer est le mme quel que soit la balise et peut donc
tre plac dans une variable. Nous obtenons donc le template suivant :

	my $ELT_CONTENT = q!%%join '', @_%%!;
	my $HTML_T1 = new Parse::Template(
			    'DOC' => '%%P(B("text in bold"), I("text in italic"))%%',
			    'P' => qq!<P>$ELT_CONTENT</P>!,
			    'B' => qq!<B>$ELT_CONTENT</B>!,
			    'I' => qq!<I>$ELT_CONTENT</I>!,
			   );
	print $HTML_T1->eval('DOC'), "\n";

Nous pouvons aller plus loin en exploitant la variable C<$part> qui
est dfinie par dfaut dans l'environnement d'valuation du template :

	$ELT_CONTENT = q!%%"<$part>" . join('', @_) . "</$part>"%%!;
	$HTML_T2 = new Parse::Template(
			    'DOC' => '%%P(B("text in bold"), I("text in italic"))%%',
			    'P' => qq!$ELT_CONTENT!,
			    'B' => qq!$ELT_CONTENT!,
			    'I' => qq!$ELT_CONTENT!,
			   );
	print $HTML_T2->eval('DOC'), "\n";


Voyons une autre tape qui automatise la production des expressions :

	$DOC = q!P(B("text in bold"), I("text in italic"))!;

	$ELT_CONTENT = q!%%"<$part>" . join('', @_) . "</$part>"%%!;
	$HTML_T3 = new Parse::Template(
				  'DOC' => qq!%%$DOC%%!,
				  map { $_ => $ELT_CONTENT } qw(P B I)
				 );
	print $HTML_T3->eval('DOC'), "\n";


Moyennant une dernire transformation il est possible d'utiliser une
notation invocation de mthode pour procder  la gnration :

	$ELT_CONTENT = q!%%shift(@_); "<$part>" . join('', @_) . "</$part>"%%!;
	$HTML_T4 = new Parse::Template(
				  map { $_ => $ELT_CONTENT } qw(P B I)
				 );
	print $HTML_T4->P(
	                  $HTML_T4->B("text in bold"), 
		          $HTML_T4->I("text in italic")
                         ), "\n";

C<Parse::Template> a t initialement cre pour servir de gnrateur
de code  la classe C<Parse::Lex>. Vous trouverez d'autres exemples
d'utilisation dans les classes C<Parse::Lex>, C<Parse::CLex> et
C<Parse::Token>.

#=head1 APROPOS DE LA VERSION EN COURS

Il s'agit d'un module exprimental. Je suis trs intress par vos
remarques et suggestions.

#=head1 BUG

Les instances ne sont pas dtruites. Donc n'utilisez pas cette classe
pour crer un grand nombre d'instances.

#=head1 AUTEUR

Philippe Verdret avec l'aide d'Ocrat pour la traduction de la
documentation en anglais.

#=head1 COPYRIGHT

Copyright (c) 1995-1999 Philippe Verdret. All rights reserved.
This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

#=cut
