use strict;
use warnings;

package App::Embra::Role::Logging;
$App::Embra::Role::Logging::VERSION = '0.001'; # TRIAL
# ABSTRACT: adds logging methods to a class

use Log::Any;
use Method::Signatures;
use Moo::Role;



has 'log_prefix' => (
    is => 'lazy',
);


method _build_log_prefix { 
    return q{};
}


has 'logger' => (
    is => 'lazy',
    handles => [ Log::Any->logging_methods ],
);


method _build_logger {
    return Log::Any->get_logger;
}

for my $logging_method ( Log::Any->logging_methods ) {
    around $logging_method => func( $orig, $self, $log_msg ) {
        $self->logger->$logging_method( $self->log_prefix . $log_msg );
    };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::Logging - adds logging methods to a class

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role adds some basic logging methods to its implementer. It provides L<a C<logger> attribute|/logger>r which handles all of the standard log methods.

=head1 ATTRIBUTES

=head2 log_prefix

A string to prefix to all logged messages. Defaults to the empty string.

=head2 logger

The object which handles all the logging. It must accept any of L<Log::Any's logging methods|Log::Any/logging_methods>.

=head1 METHODS

=head2 _build_log_prefix

    say $app_embra_role_logging->_build_log_prefix;

Returns the log prefix. Present only so it can be modified by implementors with L<around|Method::Modifiers/around>.

=head2 _build_logger

    my $logger = $app_embra_role_logging->_build_logger;

Returns a new instance of L<Log::Any>. Present only so it can be modified by implementors with L<around|Method::Modifiers/around>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
