/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.html5;

import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.html5.Utils;

public class SetLocationContext
extends WebDriverHandler<Void> {
    private volatile Location location;

    public SetLocationContext(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        double altitude;
        double longitude;
        double latitude;
        super.setJsonParameters(allParameters);
        Map locationMap = (Map)allParameters.get("location");
        try {
            latitude = ((Number)locationMap.get("latitude")).doubleValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-double) latitude location passed: " + locationMap.get("latitude"), ex);
        }
        try {
            longitude = ((Number)locationMap.get("longitude")).doubleValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-double) longitude location passed: " + locationMap.get("longitude"), ex);
        }
        try {
            altitude = ((Number)locationMap.get("altitude")).doubleValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-double) altitude location passed: " + locationMap.get("altitude"), ex);
        }
        this.location = new Location(latitude, longitude, altitude);
    }

    @Override
    public Void call() throws Exception {
        Utils.getLocationContext(this.getUnwrappedDriver()).setLocation(this.location);
        return null;
    }

    public String toString() {
        return String.format("[set location context: %s]", this.location.toString());
    }
}

