/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseArrayIterator<T extends Item>
implements UnfailingIterator<T>,
ReversibleIterator<T>,
LookaheadIterator<T>,
LastPositionFinder<T> {
    T[] items;
    int index = 0;
    int start;
    int end;
    T current = null;

    public ReverseArrayIterator(T[] items, int start, int end) {
        this.items = items;
        this.end = end;
        this.start = start;
        this.index = end - 1;
    }

    @Override
    public boolean hasNext() {
        return this.index >= this.start;
    }

    @Override
    public T next() {
        if (this.index >= this.start) {
            this.current = this.items[this.index--];
            return this.current;
        }
        this.current = null;
        return null;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public int position() {
        if (this.index < this.start - 1) {
            return -1;
        }
        return this.end - 1 - this.index;
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    public void close() {
    }

    @Override
    public ReverseArrayIterator<T> getAnother() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    @Override
    public int getProperties() {
        return 2;
    }

    @Override
    public SequenceIterator<T> getReverseIterator() {
        return new ArrayIterator(this.items, this.start, this.end);
    }
}

