package Term::Caca::Event::Key;
our $AUTHORITY = 'cpan:YANICK';
# ABSTRACT: event generated by a keyboard activity
$Term::Caca::Event::Key::VERSION = '3.1.0';

use Moo;
extends 'Term::Caca::Event';


sub char {
    return chr Term::Caca::caca_get_event_key_ch( $_[0]->event );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Term::Caca::Event::Key - event generated by a keyboard activity

=head1 VERSION

version 3.1.0

=head1 SYNOPSIS

    use Term::Caca qw/ :events /;

    my $t = Term::Caca->new;
    while ( 1 ) {
        my $event = $t->wait_for_event( 
            mask => $ANY_KEY,
        );  
        
        print "character: ", $event->char;
    }

=head1 DESCRIPTION

Generated when a key is pressed or released.

=head1 METHODS

=head2 char()

Returns the character pressed or released.

=head1 AUTHORS

=over 4

=item *

John Beppu <beppu@cpan.org>

=item *

Yanick Champoux <yanick@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019, 2018, 2013, 2011 by John Beppu.

This is free software, licensed under:

  DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE, Version 2, December 2004

=cut
