#!/usr/bin/perl -w
#
# Network subroutines brought by the MondoRescue project
#
# $Id$
#
# Copyright B. Cornec 2008-2014
# Provided under the GPL v2

package MondoRescue::Net;

use strict 'vars';
use Data::Dumper;
use English;
use Cwd;
use ProjectBuilder::Base;
use IO::Interface::Simple;
use lib qw (lib);

# Inherit from the "Exporter" module which handles exporting functions.

use Exporter;

# Export, by default, all the functions into the namespace of
# any code which uses this module.

our @ISA = qw(Exporter);
our @EXPORT = qw(mr_net_get_config);

=pod

=head1 NAME

MondoRescue::Net, part of the mondorescue.org

=head1 DESCRIPTION

This modules provides low level and generic functions for the Mondorescue project

=head1 USAGE

=over 4

=item B<mr_net_get_config>

This function returns a hash of the network configuration of the system

=cut

#$pbdebug = 2;

sub mr_net_get_config {

my %mr_net;
my $mr_net;
pb_log(2,"mr_net_get_config start\n");
my @interfaces = IO::Interface::Simple->interfaces;

for my $if (@interfaces) {
	$mr_net{$if} = \$if;
}

return(\%mr_net);
}


=back

=head1 WEB SITES

The main Web site of the project is available at L<http://www.mondorescue.org>. Bug reports should be filled using the trac instance of the project at L<http://trac.mondorescue.org/>.

=head1 USER MAILING LIST

For community exchanges around MondoRescue please use the list L<http://sourceforge.net/mailarchive/forum.php?forum_name=mondo-devel>

=head1 AUTHORS

The MondoRescue team lead by Bruno Cornec L<mailto:bruno@mondorescue.org>.

=head1 COPYRIGHT

MondoRescue is distributed under the GPL v2.0 license or later,
described in the file C<COPYING> included with the distribution.

=cut


